//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.12 Page 478
//Title: Gassification of coal

//====================================================== 
package Ex7_12

//======================================================
model Ex7_12_a
/* Producer gas formed */

//======================================================
//Parameter Section
parameter Real F(unit = "kmol") = 100 "Dry producer gas as basis" ;

//======================================================
//Variable Section
Real C(unit = "kg") "Mass of C" ;
Real O2(unit = "kg") "Mass of O2" ;
Real H2(unit = "kg") "Mass of H2" ;
Real O2_air(unit = "kmol") "O2 supplied from air" ;
Real m(unit = "kg") "Coal gassified" ;
Real O2_c(unit = "kmol") "O2 from coal" ;
Real O2_acc(unit = "kmol") "Total O2 accounted" ;
Real O2_dec(unit = "kmol") "Total O2 decomposed from steam" ;
Real H2_dec(unit = "kmol") "Total H2 decomposed from steam" ;
Real H2_fuel(unit = "kmol") "H2 from fuel" ;
Real P(unit = "Nm^3/kg") "Dry producer gas per mole of coal" ;

//======================================================
//Equation Section
equation
C = 33*12 ;
O2 = 18.5*32 ;
H2 = 20*2 ;
O2_air = (21/79)*51 ;
m = C/0.672 ;                                   //Coal contains 67.2% C
O2_c = m*0.061/32 ;
O2_acc = O2_air+O2_c ;
O2_dec = 18.5-O2_acc ;
H2_dec = 2*O2_dec ;
H2_fuel = 20-H2_dec ;
P = F/m*22.414 ;

end Ex7_12_a ;
//======================================================

//======================================================
model Ex7_12_b
/* Air supplied */

//======================================================
//Parameter Section
parameter Real Pw(unit = "kPa") = 2.642 "Vapour pressure of water at 295.15 K from Table 6.13" ;
parameter Real Pt(unit = "kPa") = 100.7 "Total pressure" ;

//======================================================
//Reference Section
extends Ex7_12_a ;

//======================================================
//Variable Section
Real H "Absolute humidity" ;
Real H2O(unit = "kmol") "Water vapour in producer gas" ;
Real P1(unit = "Nm^3/kg") "Moist producer gas per kg of coal" ;
Real air(unit = "kg") "Dry air supplied" ;
Real m_air(unit = "kg") "Mass of gry air" ;
Real V_air(unit = "Nm^3/kg") "Volume of air per kg of coal" ;

//======================================================
//Equation Section
equation
H = Pw/(Pt-Pw) ;
H2O = H*F ;
P1 = (F+H2O)/m*22.414 ;
air = 51+O2_air ;
m_air = 51*28+O2_air*32 ;
V_air = m_air/m/29*22.414 ;

end Ex7_12_b ;
//======================================================

//======================================================
model Ex7_12_c
/* Quantity of steam */

//======================================================
//Reference Section
extends Ex7_12_b ;

//======================================================
//Variable Section
Real steam(unit = "kmol") "Steam supplied" ;
Real S "Steam supplied per unit mass of coal ";

//======================================================
//Equation Section
equation
steam = 7.62+H2O-(m*0.026/18) ;
S = steam*18/m ;

end Ex7_12_c ;
//======================================================

end Ex7_12;
//======================================================
