//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.14 Page 484
//Title: SO2 concentration

//======================================================
model Ex7_14

//======================================================
//Parameter Section

//======================================================
//Varaible Section
//Case D:
Real theo_O2(unit = "kmol") "Theoretical O2 required" ;
Real Act_O2(unit = "kmol") "Actual O2 required" ;
Real N2(unit = "kmol") "N2 entering with O2" ;
Real air(unit = "kmol") "Total dry air" ;
Real H2O(unit = "kmol") "Total moisture in flue gas" ;
Real SO2(unit = "ppm") "SO2 conc."; 
Real m_SO2(unit = "kg") "Mass of SO2"; 
//Case E:
Real theo_O21(unit = "kmol") "Theoretical O2 required" ;
Real Act_O21(unit = "kmol") "Actual O2 required" ;
Real N21(unit = "kmol") "N2 entering with O2" ;
Real air1(unit = "kmol") "Total dry air" ;
Real H2O1(unit = "kmol") "Total moisture in flue gas" ;
Real SO21(unit = "ppm") "SO2 conc."; 
Real m_SO21(unit = "kg") "Mass of SO2"; 
//======================================================
//Equation Section
equation
//Refer Case A:Example 7.4
//Refer Case B:Example 7.5
//Refer Case C:Example 7.6
//Case D: Lignite firing
//Refer Table 7.42 and 7.43
theo_O2 = 3.349 ;
Act_O2 = theo_O2*1.6 ;
N2 = (79/21)*Act_O2 ;
air = N2+Act_O2 ;
H2O = 1.5+(25/18)+air*0.0329 ;
SO2 = 0.094*10^6/29.124 ;
m_SO2 = 0.094*64*10^9/100/14860/10^3 ;
//Case E: Petcoke firing
//Refer Table 7.42 and 7.45
theo_O21 = 8.17 ;
Act_O21 = theo_O21*1.4 ;
N21 = (79/21)*Act_O21 ;
air1 = N21+Act_O21 ;
H2O1 = 1.59+(0.8/18)+air1*0.0329 ;
SO21 = 0.186*10^6/57.134 ;
m_SO21 = 0.186*64*10^9/100/34460/10^3 ;

end Ex7_14;
//======================================================