//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.3 Page 444
//Title: NHV of propane

//======================================================
model Ex7_3

//======================================================
//Parameter Section
parameter Real n(unit = "mol") = 1 "Basis of propane" ;
parameter Real GHV(unit = "kJ/mol") = 2219.17 "GHV of propane" ;

//======================================================
//Variable Section
Real H2O(unit = "g") "Mass of water produced" ;
Real NHV(unit = "kJ/mol") "NHV of C3H8" ;

//======================================================
//Equation Section
equation
H2O = 4*18.0153 ;                           //1 mol of propane produced 4 mol of water
NHV = GHV-H2O*2442.5/1000 ;

end Ex7_3;
//======================================================