////Coulson & Richardson's Chemical engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.4, Page No.: 606
//Title : The penetration theory
//===============================================
class Ex10_4

//===============================================
//Variable section
Real s(unit = "m") "thickness of the film";
Real us(unit = "m/s") "surface velocity";
Real t(unit = "s") "time";
Real l_max(unit = "m") "maximum length";

//===============================================
//Parameter section
parameter Real mu(unit = "Ns/m2") = 1e-3 "viscosity of water";
parameter Real D(unit = "m2/s") = 1.5e-9 "Diffusivity of carbondioxide in water";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
parameter Real um(unit = "m2/s") = 3e-4 "flowrate per unit perimeter";

//===============================================
//Equation section
equation
s = ((um*mu*3)/(rho*g))^(1/3);
t = (1.305/1.822)^2;
us = (rho*g*(s^2))/(2*mu);
l_max = us*t;

//===============================================
end Ex10_4;

//===============================================