//Coluson & Richardson's Chemical Engineering, Volume-01, 6th edition
//Chapter-12, Momentum, Heat and Mass transfer
//Exercise 12.3, Page No.:733
//Title: Reynolds analogy
//===================================================
package Ex12_3
  class a
  //Using the simple Reynolds analogy
    //===============================================
    //Variable section
    Real Re "Reynolds Number";
    Real Pr "Prandtl Number";
    Real h(unit = "W/m2K") "Heat transfer coefficient in W/m2K";
    Real h_1(unit = "kW/m2K") "Heat transfer coefficient in kW/m2K";
    Real teta(unit = "K") "Rise in temperature";
    //===============================================
    //Parameter section
    parameter Real d(unit = "m") = 25e-3 "dimeter of pipe";
    parameter Real rho(unit = "kg/m3") = 1000 "Density of water";
    parameter Real mu(unit = "Ns/m2") = 0.7e-3 "Viscosity of water";
    parameter Real Cp(unit = "J/kgK") = 4180 "Specific heat of water";
    parameter Real k(unit = "W/mK") = 0.65 "Thermal conductivity of water";
    parameter Real u(unit = "m/s") = 3.5 "Velocity of water";
    parameter Real teta_1(unit = "K") = 300 "Entering temperature of water in pipe";
    parameter Real teta_2(unit = "K") = 330 "Temperature of water coming out of pipe";
    parameter Real l(unit = "m") = 6 "Length";
    //===============================================
    //Library section
    extends Modelica.Constants;
    extends Modelica.Math;
    //===============================================
    //Equation section
  equation
    Re = d * rho * u / mu;
    Pr = Cp * mu / k;
    h / (Cp * rho * u) = 0.032 * Re ^ (-0.25);
    h_1 = h / 1000;
//1000 is divided to convert units from 'W/m2K' to 'kW/m2K'
//After solving integration equation becomes
    log(teta_2 - teta_1) - log(teta_2 - teta) = 4 * h * l / (d * u * rho * Cp);
    
  end a;
  //===================================================

//Using the Taylor-Prandtl modification equation

  class b
  //===============================================
      //Variable section
      Real Re "Reynolds Number";
      Real Pr "Prandtl Number";
      Real h(unit = "W/m2K") "Heat transfer coefficient in W/m2K";
      Real h_1(unit = "kW/m2K") "Heat transfer coefficient in kW/m2K";
      Real teta(unit = "K") "Rise in temperature";
      //===============================================
      //Parameter section
      parameter Real d(unit = "m") = 25e-3 "dimeter of pipe";
      parameter Real rho(unit = "kg/m3") = 1000 "Density of water";
      parameter Real mu(unit = "Ns/m2") = 0.7e-3 "Viscosity of water";
      parameter Real Cp(unit = "J/kgK") = 4180 "Specific heat of water";
      parameter Real k(unit = "W/mK") = 0.65 "Thermal conductivity of water";
      parameter Real u(unit = "m/s") = 3.5 "Velocity of water";
      parameter Real teta_1(unit = "K") = 300 "Entering temperature of water in pipe";
      parameter Real teta_2(unit = "K") = 330 "Temperature of water coming out of pipe";
      parameter Real l(unit = "m") = 6 "Length";
      //===============================================
      //Library section
      extends Modelica.Constants;
      extends Modelica.Math;
      //===============================================
      //Equation section
    equation
      Re = d * rho * u / mu;
      Pr = Cp * mu / k;
      h / (Cp * rho * u) = 0.032 * ((Re ^ (-1/4))*(1+2*(Re^(-1/8))*(Pr-1))^(-1));
      h_1 = h / 1000;
  //1000 is divided to convert units from 'W/m2K' to 'kW/m2K'
  //After solving integration equation becomes
      log(teta_2 - teta_1) - log(teta_2 - teta) = 4 * h * l / (d * u * rho * Cp);
  end b;
//=====================================================

//Using the universal velocity profile

  class c
   //===============================================
      //Variable section
      Real Re "Reynolds Number";
      Real Pr "Prandtl Number";
      Real h(unit = "W/m2K") "Heat transfer coefficient in W/m2K";
      Real h_1(unit = "kW/m2K") "Heat transfer coefficient in kW/m2K";
      Real teta(unit = "K") "Rise in temperature";
      
      //===============================================
      //Parameter section
      
      parameter Real d(unit = "m") = 25e-3 "dimeter of pipe";
      parameter Real rho(unit = "kg/m3") = 1000 "Density of water";
      parameter Real mu(unit = "Ns/m2") = 0.7e-3 "Viscosity of water";
      parameter Real Cp(unit = "J/kgK") = 4180 "Specific heat of water";
      parameter Real k(unit = "W/mK") = 0.65 "Thermal conductivity of water";
      parameter Real u(unit = "m/s") = 3.5 "Velocity of water";
      parameter Real teta_1(unit = "K") = 300 "Entering temperature of water in pipe";
      parameter Real teta_2(unit = "K") = 330 "Temperature of water coming out of pipe";
      parameter Real l(unit = "m") = 6 "Length";
      
      //===============================================
      //Library section
          extends Modelica.Math;
      
      //===============================================
      //Equation section
    equation
      Re = d * rho * u / mu;
      Pr = Cp * mu / k;
      h/(Cp*rho*u)=((0.032*(Re^(-1/4)))*(1+0.82*(Re^(-1/8))*((Pr-1)+(log((0.83*Pr)+0.17))))^(-1));
      h_1 = h / 1000;
  //1000 is divided to convert units from 'W/m2K' to 'kW/m2K'
  //After solving integration equation becomes
      log(teta_2 - teta_1) - log(teta_2 - teta) =( 4 * h * l / (d * u * rho * Cp));
  end c;
//=================================================

//Using Nusselt Number

  class d
  //===============================================
      //Variable section
      Real Re "Reynolds Number";
      Real Pr "Prandtl Number";
      Real h(unit = "W/m2K") "Heat transfer coefficient in W/m2K";
      Real h_1(unit = "kW/m2K") "Heat transfer coefficient in kW/m2K";
      Real teta(unit = "K") "Rise in temperature";
      
      //===============================================
      //Parameter section
      
      parameter Real d(unit = "m") = 25e-3 "dimeter of pipe";
      parameter Real rho(unit = "kg/m3") = 1000 "Density of water";
      parameter Real mu(unit = "Ns/m2") = 0.7e-3 "Viscosity of water";
      parameter Real Cp(unit = "J/kgK") = 4180 "Specific heat of water";
      parameter Real k(unit = "W/mK") = 0.65 "Thermal conductivity of water";
      parameter Real u(unit = "m/s") = 3.5 "Velocity of water";
      parameter Real teta_1(unit = "K") = 300 "Entering temperature of water in pipe";
      parameter Real teta_2(unit = "K") = 330 "Temperature of water coming out of pipe";
      parameter Real l(unit = "m") = 6 "Length";
      
      //===============================================
      //Library section
          extends Modelica.Math;
      
      //===============================================
      //Equation section
    equation
      Re = d * rho * u / mu;
      Pr = Cp * mu / k;
    (h*d)/k = (0.023*(Re^0.8)*(Pr^0.33));
      h_1 = h / 1000;
  //1000 is divided to convert units from 'W/m2K' to 'kW/m2K'
  //After solving integration equation becomes
      log(teta_2 - teta_1) - log(teta_2 - teta) =( 4 * h * l / (d * u * rho * Cp));
  end d;end Ex12_3;
