//Coulson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:13, Humidification and water cooling
//Exercise:13.6, Page No.: 755
//Title: Mixing of two streams of humid gas
//================================================

class Ex13_6
//=============================================
//Variable section
Real H3(unit = "kJ/kg") "Enthalpy of steam"; 
Real H_0(unit = "kg/kg") "Humidity";
Real H(unit = "kJ/kg") "Enthalpy";
Real teta(unit = "K") "Temperature";
Real H_01(unit = "kg/kg") "Humidity at 330K from chart/ figure";
Real H0(unit = "kJ/kg") "Enthalpy at 330K from chart / figure";
Real m3_1(unit = "kg/s") "Flowrate at330K";

//=============================================
//Parameter section
parameter Real m1(unit = "kg/s") = 5 "Flowrate of steam at 350K";
parameter Real m3(unit = "kg/s") = 0.15 "Flowrate of air at 320K";
parameter Real H1(unit = "kJ/kg") = 2258 "Humidity at 373K";
parameter Real T1(unit = "K") = 273 "Temperature";
parameter Real T2(unit = "K") = 373 "Temperature";
parameter Real T3(unit = "K") = 400 "Temperature";
parameter Real cp_1(unit = "kJ/kg.K") = 4.18 "Specific heat of water";
parameter Real cp_2(unit = "kJ/kg.K") = 2 "Specific heat of superheated steam";
//From figure: 13.5, Page No.: 748
// At teta1 = 320K and 20% Relative Humidity 
parameter Real H_1(unit = "kg/kg") = 0.013 "Humidity at 320K";

//=============================================
//Equation section
equation
H3 = (cp_1*(T2-T1))+H1+(cp_2*(T3-T2));
H_0-H_1 = m3/m1;
//At the intersection of H_0 = 0.043 kg/kg then
H = 165 ;
teta = 324;
//From chart 13.5, Page No.: 748 at 83% Relative Humidity  
H_01 = 0.094;
H0 = 300;
m3_1 = (m1*(H_01-H_1));
end Ex13_6;
//=============================================