// Coulson & Richardson's Chemical Engineering, Volume-01, 6th edition
//Chapter-3, Flow of liquids in pipes and open channels
// Exercise:3.7, Page No.:92
// Title: Pipe fittings
//=====================================================================

class Ex3_7

//=====================================================================
//Variable section

Real Q_s(unit = "m3/s") "volumetric flow rate in m3/sec";
Real Area(unit = "m2") "Area of pipe";
Real u(unit = "m/s") "velocity";
Real Re(unit = "-") "Reynolds number";
Real hf(unit = "m") "loss in head";
Real r(unit = "-") "relative roughness";
Real phi(unit = "-") = 0.004 "phi = R/(rho*(u^2)), for Re = 30770 pi value is 0.004, From figure: 3.7, Page No.:66";
Real Eq_l(unit = "m") "Equivalent length of pipe";
Real H(unit = "m") "Total head to be developed";
Real m(unit = "kg/s") "mass flowrate";
Real P(unit = "W") "Power required in W";
Real P_1(unit = "kW") "Power required in kW";
Real KE_H(unit = "m") "Kinetic Energy head";

//=====================================================================
//Parameter section

parameter Real Q_h(unit = "m3/h") = 2.27 "Volumetric flow rate in m3/hr";
parameter Real id(unit = "m") = 40*0.001 "inner diameter of pipe";
parameter Real l_h(unit = "m") = 150 "length of pipe horizontally";
parameter Real l_v(unit = "m") = 10 "length of pipe vertically";
parameter Real e(unit = "m") = 0.2*0.001 "roughness in pipe";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
parameter Real rho(unit = "kg/m3")= 1000 "density of water";
parameter Real n(unit = "-")= 0.6 "efficiency of pump";
parameter Real mu(unit = "Ns/m2") = 0.65*0.001 "viscosity at 320 K";
parameter Real h(unit = "m") = 1.5 "loss in head";
parameter Real L1(unit = "-") = 200 "friction loss in one pipe"; 
parameter Real L2(unit = "-") = 60 "friction loss in other pipe";

//==========================================================
//Library section

extends Modelica.Constants;

//==========================================================
//Equation section

equation
Q_s = (Q_h/3600);
r = e/id;
Area = (pi*(id^2)/4);
u = (Q_s/Area);
Re = rho*u*id/mu;
Eq_l = (l_h+l_v+((L1+L2)*id));
hf = ((4*phi*Eq_l*(u^2))/(g*id));
H = hf+h+l_v;
m = Q_s*rho;
P = (m*H*g)/n;
P_1 = P/1000;
KE_H = ((u^2)/(2*g));

end Ex3_7;
//========================================================
//=====================================================================