//Coulson & Richardson's Chemical Engineering, volume-1, 6th edition
//Chapter-6, Flow and pressure measurement
//Example:6.4, Page No.: 261
//Title: Variable area meters-Rotameters

//=====================================================
model Ex6_4

//=====================================================
//Variable section
Real G(unit = "kg/s") "mass flowrate";
Real A1(unit = "m2") "area at the height of float";
Real A2(unit = "m2") "area of annulus";
Real Af(unit = "m2") "area of float";
Real d1(unit = "m") "diameter when float is halfway up the tube";
Real R;

//=====================================================
//Parameter section
parameter Real d(unit = "m") = 25e-3 "diameter at top of tube"; 
parameter Real d2(unit = "m") = 20e-3 "diameter at bottom of tube";
parameter Real rhof(unit = "kg/m3") = 4800 "density of float";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real Vf(unit = "m3") = 6/(10^6) "volume of float";
parameter Real CD = 0.7 "discharge coefficient";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";



//=====================================================
//Library section

extends Modelica.Constants;
extends Modelica.ComplexMath;

//======================================================
//Equation section
equation
d1 = (d+d2)/2;
Af = (pi*(d2^2)/4);
A1 = (pi*(d1^2)/4);
A2 = A1-Af;
R = (1-((A2/A1)^2));
G = (CD*A2*(sqrt(2*g*Vf*rho*(rhof-rho)/(Af*R))));
//======================================================

end Ex6_4;
//======================================================