//Coluson & Richardson's Chemical Engineering,Volume-01, 6th edition
//Chapter-8, Pumping of fluids
//Exercise:8.10, Page No.:375
//Title: Power requirement for pumping through pipelines (Gases)
//=========================================


model Ex8_10
//=========================================
//Variable section
Real rho_m(unit = "kg/m3") "density of gas at mean pressure";
Real mean_P(unit = "N/m2") "mean pressure";
Real phi "friction factor";
Real del_P(unit = "N/m2") "pressure difference"; 
Real G(unit = "kg/s") "mass flowrate obtained by neglecting kinetic energy head";
Real G_1(unit = "kg/s") "mass flowrate";
Real A(unit = "m2") "Area of pipe";
Real P(unit = "W") "Power in W";
Real P1(unit = "kW") "Power in kW";
Real vm(unit = "m3/kg") "specific volume";
Real r "relative roghness";
Real Re "Reynolds number";
Real x;
//where x = (phi*(Re^2))

//===========================================
//Parameter section
parameter Real P_1(unit = "N/m2") = 2.5e6 "upstream Pressure";
parameter Real P_2(unit = "N/m2") = 2e6 "downstream pressure";
parameter Real Pa(unit = "N/m2") = 101300 "atmospheric pressure";
parameter Real Mw(unit = "kg/kmole") = 2 "Molecular weight of hydrogen";
parameter Real d(unit = "m") = 50*0.001 "diameter of pipe";
parameter Real l(unit = "m") = 500 "length of pipe";
parameter Real mu(unit = "Ns/m2") = 0.009e-3 "viscosity of hydrogen at 295K";
parameter Real eta(unit = "%") = 0.6 "efficiency of pump";
parameter Real T1(unit = "K") = 273 "Temperature at STP conditions";
parameter Real T2(unit = "K") = 295 "Temperature of gas pumped";
parameter Real v(unit = "m3") = 22.4 "volume at STP conditions";
parameter Real e(unit = "m") = 0.00005 "roughness of pipe";


//===========================================
//Library section
extends Modelica.Constants;
extends Modelica.Math;

//===========================================
//Equation section
equation
mean_P = (P_1+P_2)/2;
rho_m = ((Mw/v)*(mean_P/Pa)*(T1/T2));
del_P = P_1-P_2;
x = (del_P*(d^2)*rho_m)/((mu^2)*4*l*rho_m);
r = e/d;
//from figure:3.8, Page No.:69, for a particular value of r and phi*(Re^2) value of Re = 5.7e5
Re = 5.7e5;
G_1 = (Re*pi*mu*d)/4;
//from figure:3.7 ,Page No.:66, for a particular Re and e/d values phi value is taken as 0.0024
phi = 0.0024;
A = (pi*(d^2))/4;
G = (((P_1-P_2)*rho_m*(A^2))/((log(P_1/P_2))+(4*phi*(l/d))))^(1/2);
vm = 1/rho_m;
P = (G*mean_P*vm*(log(P_1/P_2)))/eta; 
P1 = P*0.001;


end Ex8_10;
//============================================