//Coluson & Richardson's Chemical Engineering,Volume-01, 6th edition
//Chapter-8, Pumping of fluids
//Exercise:8.7, Page No.:369
//Title: Liquids

//=============================================
model Ex8_7

//Variable section

Real Area(unit = "m2") "Area of pipe";
Real u(unit = "m/s") "velocity";
Real Re "Reynolds number";
Real phi "roughness factor";
Real r "relative roughness";
Real Eq_l(unit = "m") "Equivalent length of pipe";
Real hf(unit = "") "head loss";
Real H(unit = "m") "Total head to be developed";
Real G(unit = "kg/s") "mass flowrate";
Real P(unit = "W") "Power required";
Real P_1(unit = "W") "Power to be supplied";

//==============================================
//Parameter section
parameter Real Q(unit = "m3/s") = 600e-6 "Volumetric flowrate";
parameter Real d(unit = "m") = 40e-3 "inner diameter of pipe";
parameter Real l(unit = "m") = 150 "length of pipe in x-direction";
parameter Real z(unit = "m") = 10 "height";
parameter Real l1 = 200 "control valve is equivalent to 200 pipe diameters";
parameter Real l2 = 60 "pipe fittings are equivalent to 60 pipe diameters";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
parameter Real e(unit = "m") = 0.0002 "roughness of pipe";
parameter Real n(unit = "%") = 0.6 "efficiency of pump";
parameter Real mu(unit = "Ns/m2") = 0.65e-3 "viscosity of water at 320K";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real h1(unit = "m") = 2 "head lost across heat exchanger";

//==============================================
//Library section
extends Modelica.Constants;

//==============================================
//Equation section
equation
Area = (pi*(d^2))/4;
u = Q/Area;
Re = (rho*u*d)/mu;
r = e/d;
phi = 0.004;
// for this calculated Re and r values phi value is 0.004 from figure 3.7, Page No.:66
Eq_l = l+z+((l1+l2)*d);
hf = 4*phi*(Eq_l*(u^2))/(d*g);
H = hf+z+h1;
G = Q*rho;
P = G*H*g;
P_1 = P/n;

//In this problem kinetic head is neglected as its value is nearly equal to 0.1 percent


end Ex8_7;

//===============================================