//Coluson & Richardson's Chemical Engineering,Volume-01, 6th edition
//Chapter-8, Pumping of fluids
//Exercise:8.8, Page No.:370
//Title: Power requirement for pumping through pipelines (Liquids)

//===========================================
model Ex8_8

//===========================================
//Variable section
Real h(unit = "m of water") "head to be developed";
Real u(unit = "m/s") "velocity in pipe";
Real Q(unit = "m3/s") "discharge";
Real P(unit = "W") "Power required in W";
Real P_1(unit = "kW") "Power required in kW";

//===========================================
//Parameter section
parameter Real d(unit = "m") = 74.2e-3 "inner diameter of pipe";
parameter Real z(unit = "m") = 10 "height";
parameter Real phi = 0.003 "friction factor";
parameter Real l(unit = "m") = 200 "length";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
parameter Real n(unit = "%") = 0.5 "efficiency of pump";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";

//===========================================
//Library section
extends Modelica.Constants;

//===========================================
//Equation section
equation
Q = 0.0054;
// values of Q and h are given and they are plotted to get Q at both lines intersection
u = (Q/((pi*(d^2))/4));
h = z+((4*phi*l*(u^2))/(g*d))+((8*(u^2))/g);
P = (h*rho*Q*g)/n;
P_1 = P*0.001;

//============================================

end Ex8_8;

//============================================