//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.19, Page No.:457
//Title: Radiation from a black body
//===========================================
class Ex9_19
//==========================================
//Variable section
Real A1(unit = "m2") "Area of cylinder";
Real AR(unit = "m2") "Area of slab";
Real R1 "Ratio of radius to length";
Real R2 "Ratio of radius to length";
Real S ;
Real F12 "View factor";
Real F1R "View factor";
Real F2R "View factor";
Real F23 "View factor";
Real A2(unit = "m2") "Area of slab";
Real Q2(unit = "W") "Heat load in W";
Real Q2_1(unit = "kW") "Heat load in kW";
Real Q_2(unit = "W") "Heat load without insulation in W";
Real Q_2_1(unit = "kW") "Heat load without insulation in W";
Real r(unit = "%") "Percentage reduction";
//===========================================
//Parameter section
parameter Real d(unit = "m") = 2"diameter of cylinder";
parameter Real h(unit = "m") = 1 "depth of insulating material";
parameter Real id(unit = "m") = 2 "Inner diameter of base";
// From Figure 9.40(ii), Page No.: 452 values of i and j
//parameter Real i = 1;
//parameter Real j = 2;
parameter Real r1(unit = "m") = 1 "Radius";
parameter Real r2(unit = "m") = 1 "Radius";
parameter Real L(unit = "m") = 1 "Length of material";
parameter Real F11 = 0 "View factor for plane surface";
parameter Real sigma(unit = "W/m2K4") = 5.67e-8 "Stefan- boltzmann constant";
parameter Real T1(unit = "K") = 1500 "Temperature of surface";
parameter Real T2(unit = "K") = 373 "Temperature of boiling water";
parameter Real T3(unit = "K") = 290 "Temperature of surroundings when insulation is removed";

//===========================================
//Library section
extends Modelica.Constants;
extends Modelica.Math;
extends Modelica.ComplexMath;

//===========================================
//Equation section
equation
A1 = (pi*(d^2))/4;
AR = (pi*id*h);
//L_ri = L/ri;
//rj_L = rj/L;
//From above values F12 from figure 9.40, Page No.: 452
//F12 = 0.4;
R1 = r1/L;
R2 = r2/L;
S = 1+((1+(R2^2))/(R1^2));
F12=0.5*(S-(sqrt(S^2-4*(r2/r1)^2)));
F11+F12+F1R=1;
F2R = F1R;
F23 = F2R;
A1 = A2;

Q2=(A1*F12+((1/(A1*F1R)+(1/(A2*F2R))))^(-1))*sigma*(T1^4-T2^4);
Q2_1 = Q2/1000;
//1000 is divided to convert units from W to kW
Q_2 = sigma*A1*F12*(T1^4-T2^4)+sigma*A2*F23*(T3^4-T2^4);
Q_2_1 = Q_2/1000;
//1000 is divided to convert units from W to kW
r = ((Q2-Q_2)*100)/Q2;

end Ex9_19;
//==============================================