//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.20, Page No.:459
//Title: Radiation from a black body
//===========================================
class Ex9_20
//===========================================
//Variable section
Real r "Reflectivity";
Real Eb(unit = "W/m2") "Radiosity";
Real qo(unit = "W/m2") "Rate of radiation transfer to the surface";
Real qc(unit = "W/m2") "Convective heat transfer";
Real hc(unit = "W/m2K") "Coefficient of heat transfer";

//=========================================
//Parameter section
parameter Real e = 0.75 "Emissivity";
parameter Real  sigma(unit = "W/m2K4") = 5.67e-8 "Stefan- boltzmann constant";
parameter Real T_s(unit = "K") = 400 "Temperature";
parameter Real qI(unit = "W/m2") = 3000 "Rate of heat transfer";
parameter Real T_ambient(unit = "K") = 295 "Ambient temperature";

//=========================================
//Equation section
equation
e+r = 1;
Eb = sigma*(T_s^4);
qo = ((e*Eb)+(r*qI));
qc = ((((e+r)*e)/r)*(Eb-qo));
qc = -hc*(T_s - T_ambient);

end Ex9_20;
//=========================================