//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.21, Page No.:464
//Title: Radiation from a black body
//===========================================
class Ex9_21
//===========================================
//Variable section
Real S;
Real R1 "Ratio of radius to length";
Real R2 "Ratio of radius to length";
Real F12 "View factor";
Real A1_F12(unit = "m2") "Area multiplied with view factor for surface 1";
Real A1_F13(unit = "m2") "Area multiplied with view factor for surface 1";
Real A2_F22(unit = "m2") "Area multiplied with view factor for surface 2";
Real A2_F21(unit = "m2") "Area multiplied with view factor for surface 2";
Real A2_F23(unit = "m2") "Area multiplied with view factor for surface 2";
Real A3_F33(unit = "m2") "Area multiplied with view factor for surface 3";
Real A3_F31(unit = "m2") "Area multiplied with view factor for surface 3";
Real A3_F32(unit = "m2") "Area multiplied with view factor for surface 3";
Real Eb1(unit = "W/m2") "Radiosity of surface 1 in W/m2";
Real Eb1_1(unit = "kW/m2") "Radiosity of surface 1 in kW/m2";
Real Eb2(unit = "W/m2") "Radiosity of surface 2 in W/m2";
Real Eb2_1(unit = "kW/m2") "Radiosity of surface 2 in kW/m2";
Real Eb3(unit = "W/m2") "Radiosity of surface 3 in W/m2";
Real Eb3_1(unit = "kW/m2") "Radiosity of surface 3 in kW/m2";
Real qo_3(unit = "kW/m2") "Rate of radiation transfer to the surface 3";
Real qo_1(unit = "kW/m2") "Rate of radiation transfer to the surface 1";
Real qo_2(unit = "kW/m2") "Rate of radiation transfer to the surface 2";
Real Q1(unit = "kW") "Heat transfer";
Real Q2(unit = "kW") "Heat transfer to the plate";
//============================================
//Parameter section
parameter Real r1(unit = "m") = 0.5 "Radius";
parameter Real r2(unit = "m") = 0.5 "Radius";
parameter Real L(unit = "m") = 0.2 "Length of material";
parameter Real A1(unit = "m2") = 1.07 "Area of surface 1";
parameter Real A2(unit = "m2") = 1.07 "Area of surface 2";
parameter Real A3(unit = "m2") = 0.785 "Area of surface 3";
parameter Real F11 = 0 "View factor for plane surface";
parameter Real F22 = 0 "View factor for plane surface";
parameter Real F33 = 0 "View factor for plane surface";
parameter Real sigma(unit = "W/m2K4") = 5.67e-8 "Stefan- boltzmann constant";
parameter Real e1 = 0.75 "Emissivity for surface 1";
parameter Real e2 = 0.5 "Emissivity for surface 2";
parameter Real e3 = 1 "Emissivity for surface 3";
parameter Real r_1 = 0.25 "Reflectivity for surface 1";
parameter Real r_2 = 0.25 "Reflectivity for surface 2";
parameter Real r_3 = 0 "Reflctivity for surface 3";
parameter Real T1(unit = "K") = 1000 "Temperature at surface 1";
parameter Real T2(unit = "K") = 500 "Temperature at surface 2";
parameter Real T3(unit = "K") = 300 "Temperature at surface 3";

//=============================================
//Library section
extends Modelica.ComplexMath;

//=============================================
//Equation section
equation
R1 = r1/L;
R2 = r2/L;
S = 1+((1+(R2^2))/(R1^2));
F12=0.5*(S-(sqrt(S^2-4*(r2/r1)^2)));
A1_F12 = A1*F12;
A1_F13 = (A1-((A1*F11)+(A1*F12)));
A2_F22 = (A2*F22);
//By reciprocity rule
A2_F21 = A1_F12;
A2_F23 = A1_F13;
A3_F31 = A1_F13;
A3_F32 = A2_F23;
//By summation rule
A3_F33 = (A3-((A3_F31)+(A3_F32)));
Eb1 = sigma*(T1^4);
Eb1_1 = Eb1/1000;
//1000 is divided to convert units from W/m2 to kW/m2
Eb2 = sigma*(T2^4);
Eb2_1 = Eb2/1000;
//1000 is divided to convert units from W/m2 to kW/m2
Eb3 = sigma*(T3^4);
Eb3_1 = Eb3/1000;
//1000 is divided to convert units from W/m2 to kW/m2
qo_3 = Eb3_1;
(((A1*F11)- (A1/r_1))*qo_1)+(A2_F21*qo_2)+(A3_F31*qo_3)= (-1)*((Eb1_1*A1*e1)/r_1);
((A1_F12*qo_1)+((A2*F22)-(A2/r2))*qo_2)=(-1)*((Eb2_1*A2*e2)/r2);
Q1 = ((A1*e1/r_1)*(Eb1_1-qo_1));
Q2 = (((A2*e2)/r_2)*(Eb2_1-qo_2));

end Ex9_21;
//============================================
//Text book answer is wrong for Q2