//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.31, Page No.:544
//Title: Finned tube units
//===========================================
class Ex9_31
//===========================================
//Variable section
Real b(unit = "m") "Perimeter";
Real A(unit = "m2") "Area";
Real m(unit = "1/m");
Real T_G(unit = "K") "Temperature";

//==========================================
//Parameter section
parameter Real h(unit = "W/m2K") = 140 "Heat tansfer coefficient between gas and copper tube";
parameter Real do(unit = "m") = 10e-3 "Outer diameter";
parameter Real di(unit = "m") = 8.2e-3 "Inner diameter";
parameter Real k(unit = "W/mK") = 350 "Thermal conductivity";
parameter Real L(unit = "m") = 75e-3 "Length"; 
parameter Real T1(unit = "K") = 365 "Temperature of wall"; 
parameter Real T2(unit = "K") = 475 "Temperature of bottom of tube";

//==========================================
//Library section
extends Modelica.Constants;
extends Modelica.ComplexMath;
extends Modelica.Math;

//==========================================
//Equation section
equation
b = pi*do;
A = ((pi*((do^2)-(di^2)))/4);
m = sqrt((h*b)/(k*A));
((T_G-T1)/(T_G-T2)) = (cosh(m*L));

end Ex9_31;
//==========================================