////Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.5, Page No.:400
//Title: Unsteady state conduction
//===============================================
model Ex9_5
//===============================================
//Variable section
Real del_t(unit = "s") "Time interval"; 
Real t(unit = "s") "Time required in seconds";
Real t_1(unit = "hr") "Time required in hours";

//===============================================
//Parameter section
parameter Real del_x(unit = "m") = 50e-3;
parameter Real DH(unit = "cm2/s") = 0.0042e-4 "Thermal diffusivity";

//===============================================
//Equation section
equation
del_t = (del_x^2)/(2*DH);
t = 24*del_t;
t_1 = t/3600;
 
end Ex9_5;
//===============================================