// Coulson & Richardson's Chemical Engineering, Volume:1, 6th Edition
// Chapter-1: Units and dimensions
// Example: 1.1, Page No.:9
// Title: Conversion of units
//=========================================
class Ex1_1

//=========================================
// Variable section
Real b(unit = "lb/ft.s") "Conversion of viscosity in lb/ft.s";
Real b_1(unit = "lb/ft.hr") "Conversion of viscosity unts in lb/ft.hr";
Real c(unit = "N.s/m2") "Conversion to S.I units";

//=========================================
//Parameter section
parameter Real a(unit = "Poise") = 1; // Viscosity value in Poise 

//=========================================
// Equation section
equation
b = (a*(0.0672));
b_1 = b*3600;
c = (a*(0.1));
end Ex1_1;
//==========================================