//Coulson & Richardson's Chemical engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.12, Page No.: 643
//Title : Other spherical shapes
//==============================================
model Ex10_12

//==============================================
Real lambda(unit = "1/m");
Real L(unit = "m") "ratio of volume to ts surface area";
Real phi "Thiele modulus";
Real eta "Effectiveness factor";
Real phi_o "Thiele modulus";
Real ro(unit = "m") "radius of sphere";
Real eta_1 "Effectiveness factor of sphere";
Real phi_l "Thiele modulus";
Real eta_2 "Effectiveness factor";
Real y;

//==============================================
//Parameter section
parameter Real k(unit = "1/s") = 5e-4 "first- order rate constant";
parameter Real De(unit = "m2/s") = 2e-9 "Diffusivity of reactants";
parameter Real l(unit = "m") = 8e-3 "thickness of platelet";
parameter Real do(unit = "m") = 10e-3 "diameter of sphere";

//==============================================
//Library section
extends Modelica.Math;

//==============================================
//Equation section
equation
lambda = ((k/De)^(1/2));
L = l/2;
phi = L*lambda;
eta = (1/phi)*(tanh(phi));
ro = do/2;
phi_o = lambda*ro;
eta_1 = ((3/phi_o)*((1/tanh(phi_o))- (1/phi_o)));
phi_l = lambda*(ro/3);
y = (3*phi_l);
eta_2 = (1/phi_l)*((1/tanh(y))- (1/y));

end Ex10_12;

//==============================================