//Coulson & Richardson's Chemical engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.13, Page No.: 644
//Title : Other spherical shapes
//==============================================
model Ex10_13
//==============================================
//Variable section
Real lambda ;
Real phi "Thiele modulus";
Real eta "Effectiveness factor";
Real CA "concentration of reactant at position halfway between centre and outside the pellet";
Real L;

//==============================================
//Parameter section
parameter Real k(unit = "1/s") = 14.4 "rate constant";
parameter Real De(unit = "m2/s") = 1e-5 "Effectuve diffusivity ";
parameter Real d(unit = "m") = 5e-3 "diameter of catalyst";
parameter Real CAi(unit = "kmol/m3") = 0.015 "intial concentration";
parameter Real y(unit = "m") = 1.25e-3 "distance from halfway between centre and outside the pellet";

//==============================================
//Library section
extends Modelica.Math;

//==============================================
//Equation section
equation
lambda = ((k/De)^(1/2));
L = d/2;
phi = ((k/De)^(1/2))*L;
eta = ((1/phi)*(tanh(phi)));
CA = CAi*((cosh(lambda*y))/(cosh(lambda*L)));


end Ex10_13;
//=============================================