//Coulson & Richardson's Chemical engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.2, Page No.: 582
//Title : Diffusivity of gases and vapours 
//===============================================

model Ex10_2
//===============================================
//Variable section
Real CT(unit = "kmol/m3") "Total concentration";
Real CA(unit = "kmol/m3") "Saturation concentration at interface";
Real CB_2(unit = "kmol/m3") "";
Real CB_M(unit = "kmol/m3") "logarithmic mean of CB_1 and CB_2";
Real D(unit = "m2/s") "Diffusivity of CCl4 vapour in air";
Real CB_1(unit = "kmol/m3") "";

//===============================================
//Parameter section
parameter Real v(unit = "m3") = 22.4 "molecular volume";
parameter Real T1(unit = "K") = 273 "Temperature at STP conditions";
parameter Real T2(unit = "K") = 321 "Temperature of CCl4";
parameter Real M(unit = "kg/kmol") = 154 "Molecular weight of CCl4";
parameter Real P(unit = "N/m2") = 101.3e3 "Atmospheric pressure";
parameter Real rho_l(unit = "kg/m3") = 1540 "density of CCl4";
parameter Real P2(unit = "N/m2") = 37.6e3 "pressure at 320K";
parameter Real s(unit = "s/m2") = 3.1e7 "slope from graph plotted between 't/(L-to)' and '(L-Lo)";

//================================================
//Library section
extends Modelica.Constants;

//================================================
//Equation section
equation
CT = ((1/v)*(T1/T2));
CA = (P2/P)*CT;
CB_2 = ((P-P2)/P)*CT;
CB_1 = CT;
CB_M = ((CB_1-CB_2)/(log(CB_1/CB_2)));
D = ((rho_l*CB_M)/(2*M*CA*CT*s));

//==================================================
end Ex10_2;
//==================================================