//Coulson & Richardson's Chemical Engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.6, Page No.: 608
//Title : The Penetration theory
//===========================================
model Ex10_6

//===========================================
//Variable section
//Real mole1 "moles transfered at y = 0";
//Real mole2 "moles transfered at y = 1e-3";
//Real CAi "Intial concentration";
Real r "Percent of material retained in layer";
Real r_1(unit = "%") "Percent of material retained in layer";
//===========================================
//Parameter section
parameter Real D(unit = "m2/s") = 4e-9 "Diffusivity of Co2 in ethanol";
parameter Real te(unit = "s") = 100 "time taken";
parameter Real y2(unit = "m") = 1e-3 ;
parameter Real x = 2.63e-1 "error fraction of (y/(2*(D*t)^(1/2)))";

//============================================
//Library section
extends Modelica.Constants;
extends Modelica.Math;
extends Modelica.ComplexMath;

//============================================
//Equation section
equation
//mole1 = 2*CAi*(sqrt((D*t)/pi));
//mole2 = CAi*(2*sqrt((D*t)/pi)*exp((y2^2)/(4*D*t))-(y2*x));

//r = (mole1-mole2)/mole1;
r = (2*(sqrt((D*te)/pi))-((2*sqrt((D*te)/pi))*exp(-(y2^2)/(4*D*te))-(y2*x)))/(2*(sqrt((D*te)/pi)));
r_1 = r*100;

end Ex10_6;

//============================================