//Coulson & Richardson's Chemical engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.8, Page No.: 621
//Title : Mass transfer coefficients 
//===============================================

model Ex10_8
//===============================================
//Variable section
Real D_mean(unit = "N/m2") "mean driving force";
Real AA(unit = "kmol/s") "Ammonia absorbed";
Real A(unit = "m2") "Wetted surface";
Real K_G(unit = "kmol/(m2s(N/m2))") "Overall transfer coefficient";

//===============================================
//Parameter section
parameter Real Pi(unit = "N/m2") = 7.5e3 "Driving force at inlet";
parameter Real Po(unit = "N/m2") = 2e3 "Driving force at outlet";
parameter Real m(unit = "kmol/s") = 2e-5 "Air rate";
parameter Real d(unit = "m") = 15e-3 "diameter of tube";
parameter Real l(unit = "m") = 825e-3 "length of tube";
parameter Real P(unit = "N/m2") = 101.3e3 "Atmospheric Pressure";

//================================================
//Library section
extends Modelica.Constants;
extends Modelica.Math;

//================================================
//Equation section
equation
D_mean = ((Pi-Po)/(log(Pi/Po)));
AA = m*((Pi/(P-Pi))-(Po/(P-Po)));
A = pi*d*l;
K_G = AA/(A*D_mean);

//================================================
end Ex10_8;

//================================================