//Coluson & Richardson's Chemical Engineering, Volume-01, 6th edition
//Chapter-12, Momentum, Heat and Mass transfer
//Exercise 12.4, Page No.:734
//Title: Reynolds analogy
//===================================================
package Ex12_4
  class a
    //Using the simple Reynolds analogy
    //===============================================
    //Variable section
    Real Re "Reynolds Number";
    Real Pr "Prandtl Number";
    Real h(unit = "W/m2K") "Heat transfer coefficient in W/m2K";
    Real h_1(unit = "kW/m2K") "Heat transfer coefficient in kW/m2K";
    Real teta(unit = "K") "Rise in temperature";
    Real rho(unit = "kg/m3") "Density of air";
    //===============================================
    //Parameter section
    parameter Real d(unit = "m") = 25e-3 "dimeter of pipe";
    parameter Real mu(unit = "Ns/m2") = 0.018e-3 "Viscosity of air";
    parameter Real Cp(unit = "J/kgK") = 1.003e3 "Specific heat of air";
    parameter Real k(unit = "W/mK") = 0.024 "Thermal conductivity of air";
    parameter Real u(unit = "m/s") = 3.5 "Velocity of air";
    parameter Real teta_1(unit = "K") = 290 "Entering temperature of air in pipe";
    parameter Real teta_2(unit = "K") = 350 "Temperature of air coming out of pipe";
    parameter Real l(unit = "m") = 6 "Length";
    parameter Real M(unit = "kg/kmole") = 29 "Molecular weight of air";
    parameter Real v(unit = "m3") = 22.414 "Volume at STP conditions";
    parameter Real T(unit = "K") = 273 "Temperature at STP conditions";
    parameter Real T1(unit = "K") = 310 "Temperature";
    //===============================================
    //Library section
    extends Modelica.Constants;
    extends Modelica.Math;
    //===============================================
    //Equation section
  equation
    rho = M / v * (T / T1);
    Re = d * rho * u / mu;
    Pr = Cp * mu / k;
    h / (Cp * rho * u) = 0.032 * Re ^ (-0.25);
    h_1 = h / 1000;
//1000 is divided to convert units from 'W/m2K' to 'kW/m2K'
//After solving integration equation becomes
    log(teta_2 - teta_1) - log(teta_2 - teta) = 4 * h * l / (d * u * rho * Cp);
  end a;

  //====================================================


class b
//Using the Taylor-Prandtl modification equation
  //===============================================
    //Variable section
    Real Re "Reynolds Number";
    Real Pr "Prandtl Number";
    Real h(unit = "W/m2K") "Heat transfer coefficient in W/m2K";
    Real h_1(unit = "kW/m2K") "Heat transfer coefficient in kW/m2K";
    Real teta(unit = "K") "Rise in temperature";
    Real rho(unit = "kg/m3") "Density of air";
    //===============================================
    //Parameter section
    parameter Real d(unit = "m") = 25e-3 "dimeter of pipe";
    parameter Real mu(unit = "Ns/m2") = 0.018e-3 "Viscosity of air";
    parameter Real Cp(unit = "J/kgK") = 1.003e3 "Specific heat of air";
    parameter Real k(unit = "W/mK") = 0.024 "Thermal conductivity of air";
    parameter Real u(unit = "m/s") = 3.5 "Velocity of air";
    parameter Real teta_1(unit = "K") = 290 "Entering temperature of air in pipe";
    parameter Real teta_2(unit = "K") = 350 "Temperature of air coming out of pipe";
    parameter Real l(unit = "m") = 6 "Length";
    parameter Real M(unit = "kg/kmole") = 29 "Molecular weight of air";
    parameter Real v(unit = "m3") = 22.414 "Volume at STP conditions";
    parameter Real T(unit = "K") = 273 "Temperature at STP conditions";
    parameter Real T1(unit = "K") = 310 "Temperature";
    //===============================================
    //Library section
    extends Modelica.Constants;
    extends Modelica.Math;
    //===============================================
    //Equation section
  equation
    rho = M / v * (T / T1);
    Re = d * rho * u / mu;
    Pr = Cp * mu / k;
      h / (Cp * rho * u) = 0.032 * ((Re ^ (-1/4))*(1+2*(Re^(-1/8))*(Pr-1))^(-1));
    h_1 = h / 1000;
  //1000 is divided to convert units from 'W/m2K' to 'kW/m2K'
  //After solving integration equation becomes
    log(teta_2 - teta_1) - log(teta_2 - teta) = 4 * h * l / (d * u * rho * Cp);
  end b;

  class c
  //Using the universal velocity profile
  //===============================================
    //Variable section
    Real Re "Reynolds Number";
    Real Pr "Prandtl Number";
    Real h(unit = "W/m2K") "Heat transfer coefficient in W/m2K";
    Real h_1(unit = "kW/m2K") "Heat transfer coefficient in kW/m2K";
    Real teta(unit = "K") "Rise in temperature";
    Real rho(unit = "kg/m3") "Density of air";
    //===============================================
    //Parameter section
    parameter Real d(unit = "m") = 25e-3 "dimeter of pipe";
    parameter Real mu(unit = "Ns/m2") = 0.018e-3 "Viscosity of air";
    parameter Real Cp(unit = "J/kgK") = 1.003e3 "Specific heat of air";
    parameter Real k(unit = "W/mK") = 0.024 "Thermal conductivity of air";
    parameter Real u(unit = "m/s") = 3.5 "Velocity of air";
    parameter Real teta_1(unit = "K") = 290 "Entering temperature of air in pipe";
    parameter Real teta_2(unit = "K") = 350 "Temperature of air coming out of pipe";
    parameter Real l(unit = "m") = 6 "Length";
    parameter Real M(unit = "kg/kmole") = 29 "Molecular weight of air";
    parameter Real v(unit = "m3") = 22.414 "Volume at STP conditions";
    parameter Real T(unit = "K") = 273 "Temperature at STP conditions";
    parameter Real T1(unit = "K") = 310 "Temperature";
    //===============================================
    //Library section
    extends Modelica.Constants;
    extends Modelica.Math;
    //===============================================
    //Equation section
  equation
    rho = M / v * (T / T1);
    Re = d * rho * u / mu;
    Pr = Cp * mu / k;
    h/(Cp*rho*u)=((0.032*(Re^(-1/4)))*(1+0.82*(Re^(-1/8))*((Pr-1)+(log((0.83*Pr)+0.17))))^(-1));
    h_1 = h / 1000;
  //1000 is divided to convert units from 'W/m2K' to 'kW/m2K'
  //After solving integration equation becomes
    log(teta_2 - teta_1) - log(teta_2 - teta) = 4 * h * l / (d * u * rho * Cp);
  end c;

  class d
  //Using Nusselt Number
  //===============================================
    //Variable section
    Real Re "Reynolds Number";
    Real Pr "Prandtl Number";
    Real h(unit = "W/m2K") "Heat transfer coefficient in W/m2K";
    Real h_1(unit = "kW/m2K") "Heat transfer coefficient in kW/m2K";
    Real teta(unit = "K") "Rise in temperature";
    Real rho(unit = "kg/m3") "Density of air";
    //===============================================
    //Parameter section
    parameter Real d(unit = "m") = 25e-3 "dimeter of pipe";
    parameter Real mu(unit = "Ns/m2") = 0.018e-3 "Viscosity of air";
    parameter Real Cp(unit = "J/kgK") = 1.003e3 "Specific heat of air";
    parameter Real k(unit = "W/mK") = 0.024 "Thermal conductivity of air";
    parameter Real u(unit = "m/s") = 3.5 "Velocity of air";
    parameter Real teta_1(unit = "K") = 290 "Entering temperature of air in pipe";
    parameter Real teta_2(unit = "K") = 350 "Temperature of air coming out of pipe";
    parameter Real l(unit = "m") = 6 "Length";
    parameter Real M(unit = "kg/kmole") = 29 "Molecular weight of air";
    parameter Real v(unit = "m3") = 22.414 "Volume at STP conditions";
    parameter Real T(unit = "K") = 273 "Temperature at STP conditions";
    parameter Real T1(unit = "K") = 310 "Temperature";
    //===============================================
    //Library section
    extends Modelica.Constants;
    extends Modelica.Math;
    //===============================================
    //Equation section
  equation
    rho = M / v * (T / T1);
    Re = d * rho * u / mu;
    Pr = Cp * mu / k;
    (h*d)/k = (0.023*(Re^0.8)*(Pr^0.33));
    h_1 = h / 1000;
  //1000 is divided to convert units from 'W/m2K' to 'kW/m2K'
  //After solving integration equation becomes
    log(teta_2 - teta_1) - log(teta_2 - teta) = 4 * h * l / (d * u * rho * Cp);
  end d;
end Ex12_4;
