//Coulson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:13, Humidification and water cooling
//Exercise:13.2, Page No.: 741
//Title: Humidification terms

//================================================
class Ex13_2
//================================================
//Variable section
Real Pw(unit = "N/m2") "partial pressure of water vapour at 300K";
Real m_w(unit = "kg") "mass of water vapour";
Real m_a(unit = "kg") "mass of air";
Real Vs_w(unit = "m3/kg") "Specific volumeof water vapour at 0.9kN/m2";
Real Vs_a(unit = "m3/kg") "Specific volume of air at 100.4kN/m2";
Real H(unit = "kg/kg") "Humidity";
Real Hv(unit = "m3/kg") "Humid Volume";
Real H1(unit = "kg/kg") "Humidity using approximate relationship";
Real HP(unit = "percent") "Percentage Humidity";

//=================================================
//Parameter section
parameter Real Pwo(unit = "N/m2") = 3.6e3 "partial pressure of benzene in saturated gas";
parameter Real RH = 25 "Relative humidity";
parameter Real Mw(unit = "kg/kmol") = 18 "Molecular weight of water vapour";
parameter Real Ma(unit = "kg/kmol") = 29 "Molecular weight of air";
parameter Real P(unit = "N/m2") = 101.3e3 "Pressure";
parameter Real R(unit = "J/kmol.K") = 8314 "Universal gas constant";
parameter Real T(unit = "K") = 300 "Temperature";

//=================================================
//Equation section
equation
Pw = Pwo*(RH/100);
m_w = (Pw*Mw)/(R*T);
m_a = (P - Pw)*Ma/(R*T);
Vs_w = (1/m_w);
Vs_a = (1/m_a);
H = m_w/m_a;
H1 = Mw*Pw/(Ma*P);
Hv =  Vs_a;
HP = ((P-Pwo)/(P-Pw))*RH;

end Ex13_2;
//=================================================