//Coulson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:13, Humidification and water cooling
//Exercise:13.8, Page No.: 766
//Title: Design of natural-draught towers
//================================================
class Ex13_8
//================================================
//Variable section
Real mean_T(unit = "K") "Mean temperature";
Real del_T(unit = "K") "Temperature range for water";
Real del_T1(unit = "K") "Change in water temperature in passing through tower";
Real del_H(unit = "kg/kg") "difference in enthalpy";
Real Dt "duty coefficient";
Real Ab(unit = "m2") "Area of column";
Real Db(unit = "m") "Internal diameter of column ";

//================================================
//Parameter section
parameter Real T1(unit = "K") = 301 "Temperature of water entering the tower";
parameter Real T2(unit = "K") = 294 "Temperature of water leaving the tower";
parameter Real Tb1(unit = "K") = 287 "Dry bulb temperature of air";
parameter Real Tb2(unit = "K") = 284 "Wet bulb temperature";
parameter Real H1(unit = "kJ/kg") = 92.6 "Enthalpy at mean temperature";
parameter Real H2(unit = "kJ/kg") = 49.5 "Enthalpy at dry bulb temperature";
parameter Real m(unit = "kg/s") = 4810 "mass flowrate";
parameter Real zt(unit = "m") = 100 "Tower height";
parameter Real Ct = 5 "Performance coefficient";

//================================================
//Library section
extends Modelica.Constants;
extends Modelica.ComplexMath;

//================================================
//Equation section
equation
del_T = T1-T2;
mean_T = (T1+T2)/2;
del_T1 = mean_T-Tb1;
del_H = H1-H2;
m/Dt = (0.00369*(del_H/del_T))*((del_T1+(0.0752*del_H))^(0.5));
Dt = 19.5*Ab*((zt^0.5)/(Ct^1.5));
Db = sqrt((Ab*4)/pi);


end Ex13_8;
//===============================================