// coulson & Richardson's Chemical Engineering, Volume-1, 6th Edition
// Chapter-2: Flow of Fluids- Energy and Momentum relationships
// Example: 2.1,Page No.: 36

//=============================================
class Ex2_1

//=============================================
//variable section

Real a(unit = "(((N/m2)*(m2)^3)/(kmol)^2)");
Real b(unit = "m3/kmol");
Real Tr(unit = "K");
Real Pr(unit = "Pa");

//V is volume of vessel using ideal gas law
Real V(unit = "m3"); 
//Vv is volume of vessel using van der Walls equation
Real Vv(start = 0.05, unit = "m3"); 
//Vc is volume of vessel using conpressibility factor
Real Vc(unit = "m3");


//==========================================================================
// Parameter section

parameter Real P(unit = "Pa") = (60*10^6); // Pressure 
// 10^6 is multiplied to convert MPa to Pa
parameter Real T(unit = "K") = 320; // Temperature
parameter Real R(unit = "J/kmol.K") = 8314; // Universal gas constant
parameter Real n(unit = "kmol") = 1; 
parameter Real Tc(unit = "K")= 191; // Critical temperature of methane from Appendix tables
parameter Real Pc(unit = "Pa") = (4.64*10^6); // critical presure of methane rom Appendix tables
// 10^6 is multiplied to convert MPa to Pa
parameter Real Z(unit = "-") = 1.33; // Compressibility factor


//========================================
// Equation section


equation
V =(n*R*T/(P)); // Ideal gas law
a=((27*(R^2)*(Tc^2))/(64*Pc));
b=((R*Tc)/(8*Pc));

(n*R*T)=((P+(n*a)/Vv^2)*(Vv-(n*b))); // van der Walls equation
Vc= ((Z*n*R*T)/P);
Tr=(T/Tc);
Pr=(P/Pc);
end Ex2_1;
//=========================================================================