// Coulson & Richardson's Chemical Engineering
// Unit-02
// Flow of fluids- Energy and momentum relationships
// Exercise-2.3, Page No.: 43
// Title: Momentum changes in a fluid
//==============================================

model Ex2_3

//==============================================
//Variable section

Real A(unit = "m2") "Area of pipe";
Real G(unit = "kg/s")"mass discharge rate of water";
Real p(unit = "N")"Reaction force or Rate of change of momentum";

//================================================
//Parameter section

parameter Real u(unit = "m/s") = 25 "velocity in pipe";
parameter Real d(unit = "m") = (25e-3) "diameter of pipe";
// 0.001 is multiplied to convert "mm" to "m"
parameter Real rho(unit = "kg/m3")=1000"density of water";

//================================================
//Library section

extends Modelica.Constants;

//================================================
//Equation section

equation
A = ((pi*(d^2))/4);
G = (rho*A*u);
p = (G*u);
end Ex2_3;

//=================================================