// coluson & Richardson's Chemical Engineering, Volume-01, 6th Edition
// Chapter-03 : Flow of liquids in pipes and open channels
// Title : Effect of roughness of pipe surfaces
// Exercise: 3.1, Page No.: 70
//==========================================
class Ex3_1

//==========================================
// Variable section

Real Re(unit = "-") "Reynolds number";
Real Area(unit = "m2")"Area of pipe";
Real u(unit = "m/s")"velocity";
Real delP(unit = "kPa")"Pressure drop";
Real r(unit = "-") "Roughness factor";

//===========================================
//Library section
extends Modelica.Constants;

//==========================================
//parameter section
parameter Real rho(unit = "kg/m3") = 1840"density of 98% sulphuric acid";
parameter Real mu(unit = "Ns/m2") = 25*0.001 "viscosity of 98% sulphuric acid";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real G(unit = "Kg/s") = 1.25 "mass flow rate";
parameter Real d(unit = "m") = (25*0.001) "diameter of pipe";
parameter Real z(unit = "m") = 12 "height of pipe";
parameter Real l(unit = "m") = 30 "length of pipe";
parameter Real e(unit = "m") = 0.00005 "for mild steel roughness e will be in range of 0.05mm to 0.5mm";
parameter Real phi(unit = "-") = 0.006 "phi = (R/rho*(u^2)) value is taken from chart Figure 3.7, Page No.:66";

//==========================================
//Equation section
equation
Area = ((pi*(d^2))/4);
u = (G/(rho*Area));
Re = ((d*rho*u)/mu);
r = (e/d);
delP = (rho*((u^2)*(((4*phi*l)/d)+0.5)+(g*z)))*0.001;
end Ex3_1;
//==========================================