// Coulsons & Richardson's Chemical Engineering, Volume-01, 6th edition
// Chapter-03, Flow of liquids in pipes and open channels
//Exercse: 3.4, Page No.:72
//Title: Effect of roughness of pipe surfaces
//==============================================
model Ex3_4
//==============================================
//Variable section
Real u1(start = 1, unit = "m/s") "Velocity between A to D tank";
Real u2(start = 1, unit = "m/s") "Velocity between B to D tank";
Real u3(start = 1, unit = "m/s") "Velocity between D to C tank";
Real Re1 "Reynolds number for u1 value";
Real Re2 "Reynolds number for u2 value";
Real Re3 "Reynolds number for u3 value";
Real Q(unit = "m3/s") "Volumetric flowrate between D and C tank";
//Real zd(unit = "m") "Height of datum line";
//Real PD(unit = "Pa") "Pressure at D";
//Real v;
//Real r "Relative roughness";
//==============================================
//Parameter section
parameter Real d1(unit = "m") = 0.3 "Diameter of pipe AD";
parameter Real d2(unit = "m") = 0.3 "Diameter of pipe BD";
parameter Real d3(unit = "m") = 0.5 "Diameter of pipe DC";
parameter Real l1(unit = "m") = 1.5e3 "Length of pipe between AD";
parameter Real l2(unit = "m") = 1.5e3 "Length of pipe between BD";
parameter Real l3(unit = "m") = 0.75e3 "Length of pipe between DC";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real rho1(unit = "kg/m3") = 1500 "Density of liquid in line AD";
parameter Real rho2(unit = "kg/m3") = 1500 "Density of liquid in line BD";
parameter Real rho3(unit = "kg/m3") = 750 "Density of liquid in line DC";
parameter Real z1(unit = "m") = 10 "Height between tank A and C";
parameter Real z2(unit = "m") = 16 "Height between tank B and C";
parameter Real rho(unit = "kg/m3") = 870 "Density of liquid";
parameter Real mu(unit = "Ns/m2") = 0.7e-3 "Viscosity of liquid";
parameter Real e(unit = "m") = 0.00005 "Roughness of mild steel"; //From table 3.1, Page No.:69
parameter Real phi = 0.002 "Assuming phi value as 0.002 'Roughness factor'";
//==============================================
//Library section
extends Modelica.Constants;

//==============================================
//Equation section
equation
//((zd-z1)*g)+(v*PD)+((4*phi*rho1*(u1^2))/d1) = 0; ------->1
//((zd-z2)*g)+(v*PD)+((4*phi*rho2*(u2^2))/d2) = 0; ------->2
//((-zd)*g)-(v*PD)+((4*phi*rho3*(u3^2))/d3) = 0; --------->3
//After solving 1 and 2 we get,
((z2-z1)*g)+(((4*phi*rho1*(u1^2))/d1)-((4*phi*rho2*(u2^2))/d2)) =0;
//After solving 2 and 3
(((4*phi*rho2*(u2^2))/d2)-((4*phi*rho3*(u3^2))/d3)) = (z2*g);
//u1 = 1.42;
//u2 = 1.87;
//u3 = 1.18;

// The flowrate in DC is equal to sum of flowrates in AD and BD
(((pi*(d1^2))/4)*u1)+(((pi*(d2^2))/4)*u2) = (((pi*(d3^2))/4)*u3);
Re1 = (d1*rho*u1)/mu;
Re2 = (d2*rho*u2)/mu;
Re3 = (d3*rho*u3)/mu;
Q = (pi*(d3^2)/4)*u3;

end Ex3_4;

//=============================================