//Coulson & Richardson's Chemical Engineering, volume-1, 6th edition
//Chapter-3, Flow of liquids in pipes and open channels
//Example:3.8, Page No.: 92
//Title: pipe fittings

//=======================================================
class Ex3_8

//=======================================================
//Variable section
Real h(unit = "m of water") "losses due to fittings";
Real l(unit = "m") "total length";
Real u(unit = "m/s") "velocity";
Real phi;
Real Re "Reynolds number";
Real Q(unit = "m3/s") "rate of discharge in m3/s";
Real G(unit = "kg/s") "mass flow rate";
Real Area(unit = "m2") "Area of pipe";


//=======================================================
//Parameter section

parameter Real l_h1(unit = "m") = 30 "length of horizontal pipe1";
parameter Real d(unit = "m") = 0.15 "diameter of pipe";
parameter Real l_v(unit = "m") = 15 "length of vertical pipe after 90 deg. elbow";
parameter Real l_h2(unit = "m") = 60 "length of horizontal pipe after 90 deg. elbow";
parameter Real r(unit = "-") = 0.01 "relative roughness";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
parameter Real H(unit = "m of water") = 10 "Total head loss";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real mu(unit = "Ns/m2") = 0.001 "viscosity of water";
//========================================================
//Library section
extends Modelica.Constants;

//========================================================
//Equation section
equation
h = ((2*0.8*(u^2))+(5*(u^2)))/(2*g);
phi = 0.0045;
l = l_h1+l_v+l_h2;
u = ((H*g*2*d)/(d+6.6*d+(4*phi*l)))^0.5;
Re = (rho*d*u)/mu;
// for Re = 4.68*10^5 and r = 0.001 phi value is equal to 0.0046
Area = (pi*(d^2)/4);
Q = (u*Area);
G = (Q*rho);

end Ex3_8;
//========================================================