//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:4, Flow of compressible fluids
//Exercise:4.4, Page No.:176
//Title: Shock waves
//===========================================
class Ex4_4
//===========================================
//Variable section
Real wc "Pressure ratio";
Real P(unit = "N/m2") "Throat pressure";
Real v1(unit = "m3/kg") "Specific volume of gas in reactor";
Real v(unit = "m3/kg") "Specific volume of gas at throat";
Real u(unit = "m/s") "Velocity at throat";
Real G(unit = "kg/s") "Initial rate of discharge";
//===========================================
//Parameter section
parameter Real gamma = 1.4 ;
parameter Real vs(unit = "m3") = 22.414 "Volume at STP conditions";
parameter Real M(unit = "kg/kmole") = 40 "Molecular weight";
parameter Real T(unit = "K") = 500 "Temperature of gas";
parameter Real P1(unit = "N/m2") = 10e6 "Pressure of gas";
parameter Real T1(unit = "K") = 273 "Temperature at STP conditions";
parameter Real P2(unit = "N/m2") = 101.3e3 "Pressure at STP conditions";
parameter Real A(unit = "m2") = 4000e-6 "Area";

//===========================================
//Library section
extends Modelica.ComplexMath;

//===========================================
//Equation section
equation
wc = (2/(gamma+1))^(gamma/(gamma-1));
P = (10*wc);
v1 = (vs/M)*(T/T1)*(P2/P1);
v = v1*((1/wc)^(1/gamma));
u = sqrt(gamma*P*(10^6)*v);
// 10^6 is multiplied to convert MN/m2 to N/m2
G = (A*u)/v;

end Ex4_4;
//===========================================