//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
// Chapter- 05, Flow of multiphase mixtures
//Exercise- 5.1, Page No.: 190
//Title : Pressure, Momentum and energy relations

//=============================================

model Ex5_1

//=============================================
//Variable section
Real Area(unit = "m2") "Area for flow";
Real Q(unit = "m3/s") "volumetric flowrate";
Real u(unit = "m/s") "velocity";
Real rho_m(unit = "kg/m3") "density of steam at 120kN/m2";
Real Q_1(unit = "m3/s") "volumetric flowrate of steam";
Real u_1(unit = "m/s") "velocity of steam";
Real Re_l "Reynolds number of liquid";
Real Re_g "Reynolds number of gas";
Real phi_l "fiction factor for liquids";
Real phi_g "friction factor for gases";
Real delP_l(unit = "(N/m2)/m") "pressure drop in liquids per unit length";
Real delP_g(unit = "(N/m2)/m") "pressure drop in gas per unit length";
Real X;
Real delPtf(unit = "N/m2") "total pressure drop in N/m2";
Real delPtf_1(unit = "kN/m2") "total pressure drop in kN/m2";
Real phig;
Real phil;

//================================================
//Parameter section
parameter Real id(unit = "m") = 75*0.001 "diameter of pipe";
parameter Real G1(unit = "kg/s") = 0.05 "steam maass flowrate";
parameter Real G2(unit = "kg/s") = 1.5 "water mass flowrate";
parameter Real T1(unit = "K") = 273 "Temperature at STP conditions";
parameter Real T2(unit = "K") = 330 "mean temperature"; 
parameter Real P(unit = "N/m2") = 120*1000 "mean pressure";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real mu_g(unit = "Ns/m2") = 0.0113e-3 "viscosity of water at 330K and 120kN/m2";
parameter Real mu_l(unit = "Ns/m2") = 0.52e-3 "viscosity of steam at 330K and 120kN/m2";
parameter Real MW(unit = "kg/kmole") = 18 "molecular weight of water";
parameter Real v(unit = "m3") = 22.4 "volume at STP conditions";
parameter Real Pa(unit = "N/m2") = 101300 "atmospheric pressure";

//================================================
//Library section
extends Modelica.Constants;

//================================================
//Equation section
equation
Area = (pi*(id^2))/4;
Q = G2/rho;
u = Q/Area;
rho_m = (MW/v)*(T1/T2)*(P/Pa);
Q_1 = G1/rho_m;
u_1 = Q_1/Area;
Re_l = (id*rho*u)/mu_l;
Re_g = (id*rho_m*u_1)/mu_g;
// both flows are in turbulent region
//from figure No.: 3.7 Page No.: 66, phi_l and phi_g values are for e/d = 0.00015
phi_l = 0.0025;
phi_g = 0.0022;
delP_l = (4*phi_l*rho*(u^2))/id;
delP_g = (4*phi_g*rho_m*(u_1^2))/id;
X = (delP_l/delP_g)^(1/2);
//from figure 5.4, Page No.:189 values of phig and phil are taken
phig = 3.95;
phil = 4.35;
delPtf = (phig^2)*delP_g;
delPtf_1 = delPtf/1000;

//================================================

end Ex5_1;

//================================================