//Coulson & Richardson Chemical Engneering, Volume:01, 6th edtion
//Chapter 5,Flow of multiphase mixtures
//Exercise:5.2, Page No.: 212
//Title : Transport of particles of low density
//============================================
model Ex5_2

//============================================
//Variable section
Real um(unit = "m/s") "velocity of water";
Real Re "Reynolds number";
Real hf(unit = "m water") "head loss";
Real hf_1(unit = "m water") "pressure drop of 300kN/m2";
Real iw(unit = "m water/m") "hydraulic gradient";
Real i(unit = "m water/m") ;
Real C "delivered concentration";
Real C_1 "delivered concentration";
Real Q(unit = "m3/s") "volumetric flowrate of sand";
Real Q_w(unit = "m3/s") "volumetric flowrate of water";
Real G(unit = "kg/s") "mass flowrate of sand in kg/s";
Real G1(unit = "tonne/hr") "mass flowrate of sand in tonne/hr";
Real phi "roughness factor";
Real s;

//============================================
//Parameter section
parameter Real dp(unit = "m") = 0.2e-3 "diameter of particle";
parameter Real id(unit = "m") = 25e-3 "inner diameter of pipe";
parameter Real l(unit = "m") = 100 "length of pipe";
parameter Real G_1(unit = "kg/s") = 0.5 "mass flowrate of water";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";
parameter Real del_P(unit = "N/m2") = 300e3 "Pressure drop";
parameter Real u_p(unit = "m/s") = 0.0239 "velocity of sand particles";
parameter Real mu(unit = "Ns/m2") = 1e-3 "viscosity of water";
parameter Real rho_m(unit = "kg/m3") = 2600 "density of sand particles";

//============================================
//Library section
extends Modelica.Constants;
extends Modelica.ComplexMath;

//============================================
//Equation section
equation
um = G_1/(rho*((pi*(id^2))/4));
Re = (um*rho*id)/mu;
//Assuming e/d = 0.008
//from figure:3.7, Page No.:66, for calculated Re value and e/d value phi = 0.0046
phi = 0.0046; 
hf = (8*phi*l*(um^2))/(id*2*g) "from equation 3.20, Page No.: 68";
iw = hf/100;
hf_1 = (del_P/(rho*g));
i = hf_1/100;
s = (rho_m/rho);
C = (((i-iw)/iw)*((um^3)/(1100*g*u_p*id*(s-1))));
C_1 = (((i-iw)/iw)*(1/121)*((((um^2)*(sqrt(g*dp*(s-1))))/(g*id*(s-1)*u_p))^1.5));
Q = G/rho_m;
Q_w = G_1/rho;
C = Q/(Q+Q_w);
G1 = (G*3600)/1000;

//=============================================
end Ex5_2; 
//=============================================