//Coulson & Richardson Chemical Engneering, Volume:01, 6th edtion
//Chapter 5,Flow of multiphase mixtures
//Exercise:5.3, Page No.: 225
//Title : Practical applications
//============================================

model Ex5_3
//============================================
//Variable section
Real G(unit = "kg/s") "mass flowrate of air";
Real Q(unit = "m3/s") "volumetric flowrate of air";
Real d(unit = "m") "diameter of pipe";
Real u(unit = "m/s") "air velocity";
Real A(unit = "m2") "Area of pipe";
Real A1(unit = "m2") "Area of nearest diameter pipe";
Real uo(unit = "m/s") "free falling velocity";
Real ug(unit = "m/s") "velocity of air";
Real us(unit = "m/s") "sand velocity";
Real Re "Reynols number";
Real phi "roughness factor";
Real delP_a(unit = "N/m2") "pressure drop of air in N/m2";
Real delP_a1(unit = "kN/m2") "pressure drop of air in kN/m2";
Real delP_x(unit = "kN/m2") "pressure drop";
Real delP(unit = "kN/m2") "total pressure drop";
Real d1(unit = "m") "diameter of nearest size pipe";

//=============================================
//Parameter section
parameter Real dp(unit = "m") = 1.25e-3 "diameter of particle";
parameter Real rho_p(unit = "kg/m3") = 2600 "density of particle";
parameter Real rho(unit = "kg/m3") = 1 "density of air";
parameter Real F(unit = "kg/s") = 1 "mass flowrate of air";
parameter Real l(unit = "m") = 200 "length of pipe ";
parameter Real mu(unit = "Ns/m2") = 1.7e-5 "viscosity of air";
parameter Real r = 5"solid to gas mass ratio";
//=============================================
//Library section
extends Modelica.Constants;
extends Modelica.ComplexMath;

//=============================================
//Equation section
equation
//Assuming solids to gas mass ratio is 5 
G = F/r;
Q = G*F;
//Assuming air velocity is 30 m/s
//Volume occupied by sand is 0.2% in air
u = 30;
A = Q/u;
d = (((4*A)/pi)^0.5);
// for sand particles size  and density free falling velocity is taken from table:5.3, Page No.:220
//for 100mm pipe because 100mm is near to 'd' value which is calculated above
uo = 4.7;
d1 = 100e-3;
//diameter of nearest size pipe
//Area with nearest size diameter
A1 = (pi*(d1^2)/4);
ug = Q/A1;
us = ug-(uo/(0.468+7.25*((uo/rho_p)^(1/2))));
Re = (d1*rho*ug)/mu;
//from figure: 3.7, Page No.: 66 phi = 0.004
phi = 0.004;
delP_a = (4*phi*l*rho*(ug^2))/(2*d1);
delP_a1 = delP_a/1000;
//1000 is divided to convert units of pressure from N/m2 to kN/m2
delP_x = delP_a1*2805*F/(uo*((us)^2));
delP = delP_a1+delP_x;

end Ex5_3;
//=============================================