//Coulson & Richardson's Chemical Engineering, volume-1, 6th edition
//Chapter-6, Flow and pressure measurement
//Example:6.1, Page No.: 252
//Title: The orifice meter

//=====================================================
class Ex6_1
//=====================================================
//Variable section

Real Area(unit = "m2") "Area of orifice";
Real Q_2(unit = "m3/s") "volumetric flow rate in 'm3/s'";
Real u(unit = "m/s") "velocity of water through orifice meter";
Real Re(unit = "-") "Reynolds number at orifice";
Real ho(unit = "m of water") "difference in level of water in m";
 Real ho1(unit = "mm of water") "difference in level of water in mm";
Real CD(unit = "-") = 0.61 "discharge coefficient, for d_r = 0.33 & Re = 15250, CD value from chart is 0.61, Figure: 6.16, Page No.:251";
Real G(unit = "kg/s") "mass flowrate";
Real x(unit = "-");
Real dr(unit = "-") "diameter ratio";


//=====================================================
//Parameter section

parameter Real do(unit = "m") = 25e-3 "diameter of orifice";
parameter Real id(unit = "m") = 75e-3 "inner diameter of pipe";
parameter Real Q_1(unit = "cm2/s") = 300 "volumetric flow rate in 'cm2/s'";
parameter Real rho(unit = "kg/m3") = 1000 "density of water";
parameter Real mu(unit = "Ns/m2") = 1e-3 "viscosity of water";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";

//======================================================
//Library section
extends Modelica.Constants;
extends Modelica.ComplexMath;

//======================================================
//Equation section
equation
Area = (pi*(do^2)/4);
Q_2 = Q_1/(10^6);
u = Q_2/Area;
Re = (do*u*rho)/mu;
dr = do/id; 
x = ((1-((do^2)/(id^2))^2)^0.5) "if x = 1 then ho is calculated";
G = (rho*Q_2);

G = (CD*Area*rho)*(sqrt(ho*2*g));
ho1 = (ho*1000); 
end Ex6_1;
//======================================================