//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chapter-6, Flow and pressure measurement
//Exercise:6.2, Page No.:253 
//Title: The orifice meter
//================================================
class Ex6_2

//================================================
//Variable section
Real G(unit = "kg/s") "mass flow rate"; 
Real ho_s(unit = "m sulphuric acid") "differential pressure";
Real Ao(unit = "m2") "Area of orifice";
Real A1(unit = "m2") "Area of pipe";
Real x;
Real delP(unit = "N/m2") "pressure drop in 'N/m2'";
Real delP1(unit = "kN/m2") "pressure drop in 'kN/m2'";

//=================================================
//Parameter section
parameter Real rho(unit = "kg/m3") = 1300 "density of sulphuric acid";
parameter Real id(unit = "m") = 50*0.001 "internal diameter of pipe";
parameter Real do(unit = "m") = 10*0.001 "diameter of orifice";
parameter Real ho(unit = "m mercury") = 0.1 "differential pressure shown in mercury manometer";
parameter Real CD = 0.61 "discharge coefficient";
parameter Real rho1(unit = "kg/m3") = 13550 "density of mercury";
parameter Real rho2(unit = "kg/m3") = 1000 "density of water";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";

//==================================================
//Library section
extends Modelica.Constants;
extends Modelica.ComplexMath;

//==================================================
//Equation section
equation
Ao = (pi*(do^2))/4;
A1 = (pi*(id^2))/4;
x = (sqrt(1-((do^2)/(id^2))^2)) "if x = 1 then 'G = CD*Ao*rho*((2*g*h)^0.5)'";
ho_s = (ho*(rho1-rho))/rho;
G = (CD*Ao*rho*(sqrt(2*g*ho_s)));
delP = rho*g*ho_s;
delP1 = delP/1000;

//==================================================
end Ex6_2;
//==================================================