//Coulson & Richardson's Chemical Engineering, volume-1, 6th edition
//Chapter-6, Flow and pressure measurement
//Example:6.6, Page No.: 263
//Title: The notch and weir
class Ex6_6
//=====================================================
//Variable section

Real Q(unit = "m3/s") "volumetric flow rate";
Real how(unit = "m") "height of liquid flowing in weir in m";
Real how_1(unit = "mm") "height of liquid flowing in weir in mm";
 
//=====================================================
//Parameter section

parameter Real L(unit = "m") = 2 "Length of weir";
parameter Real rho(unit = "kg/m3") = 650 "density of liquid";
parameter Real G(unit = "kg/s") = 15 "mass flowrate";

//======================================================
//Equation section
equation
Q = G/rho;
how = (0.666*((Q/L)^0.67));
how_1 = how*1000;

//======================================================

end Ex6_6;
//======================================================