//Coluson & Richardson Chemical Engineering, Volume:01, 6th edition
//Chapter:7.2, Liquid mixing
//Exercise:7.2, Page No.:286
//Title: Power consumption in stirred vessels
//=============================================== 
class Ex7_2
//===============================================
//Variable section
Real P(unit = "W") "Power consumption";
Real Np "Power number";
Real Re "Reynolds number";
Real Fr "Froude number";
Real A;
Real B;
Real C;

//===============================================
//Parameter section

parameter Real DT(unit = "m") = 2.28 "diameter of tank";
parameter Real D(unit = "m") = 0.5 "diameter of mixer";
parameter Real H(unit = "m") = 2.28 "depth of liquid";
parameter Real Z(unit = "m") = 0.5 "propeller distance from bottom of tank";
parameter Real rho(unit = "kg/m3") = 1650 "density of sodium hydroxide";
parameter Real mu(unit = "Ns/m2") = 50e-3 "viscosity";
parameter Real N(unit = "Hz") = 2 "rotational speed";
parameter Real g(unit = "m/s2") = 9.81 "acceleration due to gravity";

//================================================
//Equation section
equation
A = (DT/D);
B = (H/D);
C = (Z/D);
Re = ((D^2)*N*rho)/mu;
Fr = ((N^2)*D)/g;
Np = 0.5 "for Re = 16500, Fr = 0.2 from figure 7.6, Page no.:284, value of Np = 0.5";
P = (Np*rho*(N^3)*(D^5));

end Ex7_2;
//=================================================