//Coluson & Richardson's Chemical Engineering,Volume-01, 6th edition
//Chapter-8, Pumping of fluids
//Exercise:8.3, Page No.:356
//Title: Compressor efficiencies

//=====================================================
class Ex8_3

//=====================================================
//Variable section
Real V(unit = "m3") "Volume per stroke";
Real C "Compression stroke";
Real Vs(unit = "m3") "stroke volume";
Real Area(unit = "m2") "cross-sectional area of cylinder";
Real d(unit = "m") "diameter of cylinder";
Real W(unit = "J") "Work of compression per cycle";
Real P(unit = "W") "Power requirement in W";
Real P_1(unit = "kW") "Power requirement in kW";
 
//======================================================
//Parameter section
parameter Real Q(unit = "m3/s") = 0.1 "Volumetric flowrate";
parameter Real T1(unit = "K") = 273 "Temperature before compression";
parameter Real P1(unit = "kN/m2") = 101.3 "Pressure before compression";
parameter Real P2(unit = "kN/m2") = 380 "Pressure after compression";
parameter Real T2(unit = "K") = 289 "Temperature after compression";
parameter Real cc = 4e-2 "cylinder clearance";
parameter Real N(unit = "Hz") = 4 "speed";
parameter Real gamma = 1.4;
parameter Real ds(unit = "m") = 0.25 "stroke diameter";

//=======================================================
//Library section
extends Modelica.Constants;

//=======================================================
//Equation section
equation
V = (Q/N)*(T2/T1);
C = P2/P1;
Vs = V/(1+cc-(cc*(C^(1/gamma))));
Area = Vs/ds;
d = (Area/(pi/4))^0.5;
W = P1*1000*V*(gamma/(gamma-1))*((C^((gamma-1)/gamma))-1);
P = W*N;
P_1 = P*0.001;

end Ex8_3;
//=======================================================