////Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.1, Page No.:386
//Title: Individual and overall coefficients of heat transfer
//===========================================
package Ex9_1
  class Counterflow
    //====================================
    //Variable section
    Real Q(unit = "kW") "Heat load";
    Real teta2(unit = "K") "Cooling water outlet temperature";
    Real teta_m(unit = "K") "mean temperature";
    Real A(unit = "m2") "Heat transfer area";
    //====================================
    //Parameter section
    parameter Real G(unit = "kg/s") = 20 "Mass flowrate of water to be cooled";
    parameter Real G1(unit = "kg/s") = 25 "Mass flowrate of water used to cool";
    parameter Real teta1(unit = "K") = 300 "Temperature of cold water entering heat exchanger";
    parameter Real teta3(unit = "K") = 360 "Temperature of hot water entering heat exchanger";
    parameter Real teta4(unit = "K") = 340 "Temperature of hot water leaving heat exchanger";
    parameter Real U(unit = "kW/m2K") = 2 "Overall heat transfer coefficient";
    parameter Real Cp(unit = "kJ/kg") = 4.18 "Specfic heat of water";
    //=====================================
    //Library section
    extends Modelica.Math;
    //=====================================
    //Equation section
  equation
    Q = G * Cp * (teta3 - teta4);
    Q = G1 * Cp * (teta2 - teta1);
    teta_m = (teta3 - teta2 - (teta4 - teta1)) / log((teta3 - teta2) / (teta4 - teta1));
    A = Q / (U * teta_m);
  end Counterflow;

  class Cocurrent
  //====================================
    //Variable section
    Real Q(unit = "kW") "Heat load";
    Real teta2(unit = "K") "Cooling water outlet temperature";
    Real teta_m(unit = "K") "mean temperature";
    Real A(unit = "m2") "Heat transfer area";
    //====================================
    //Parameter section
    parameter Real G(unit = "kg/s") = 20 "Mass flowrate of water to be cooled";
    parameter Real G1(unit = "kg/s") = 25 "Mass flowrate of water used to cool";
    parameter Real teta1(unit = "K") = 300 "Temperature of cold water entering heat exchanger";
    parameter Real teta3(unit = "K") = 360 "Temperature of hot water entering heat exchanger";
    parameter Real teta4(unit = "K") = 340 "Temperature of hot water leaving heat exchanger";
    parameter Real U(unit = "kW/m2K") = 2 "Overall heat transfer coefficient";
    parameter Real Cp(unit = "kJ/kg") = 4.18 "Specfic heat of water";
    //=====================================
    //Library section
    extends Modelica.Math;
    //=====================================
    //Equation section
  equation
    Q = G * Cp * (teta3 - teta4);
    Q = G1 * Cp * (teta2 - teta1);
    teta_m = ((teta3 - teta1) - (teta4 - teta2)) / log((teta3 - teta1) / (teta4 - teta2));
    A = Q / (U * teta_m);
  end Cocurrent;
end Ex9_1;

//=========================================