//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.10, Page No.:432
//Title: Forced convection outside tubes
//============================================
class Ex9_10
//============================================
//Variable section
Real As(unit = "m2") "Area for flow";
Real G_s(unit = "kg/m2s") "Mass flow";
Real de(unit = "m") "Equivalent diameter";
Real Re "Reynolds number";
Real del_Pf(unit = "N/m2") "Pressure difference in N/m2";
Real del_Pf1(unit = "m of benzene") "Pressure difference in m of benzene";

//============================================
//Parameter section
parameter Real di(unit = "m") = 1 "Inner diameter of shell"; 
parameter Real lB(unit = "m") = 0.25 "Baffle spacing";
parameter Real C(unit = "m") = 6e-3 "Clearance";
parameter Real Y(unit = "m") = 25e-3 "Square pitch";
parameter Real G(unit = "kg/s") = 15 "Mass flowrate";
parameter Real do(unit = "m") = 19e-3 "Outer diameter";
parameter Real mu(unit = "Ns/m2") = 0.5e-3 "Viscosity of benzene";
parameter Real rho(unit = "kg/m3") = 881 "Density of benzene";
parameter Real N = 19 "Number of tubes";
parameter Real f = 0.280 "Friction factor, From Figure:9.29, Page No.: 431";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";

//===========================================
//Library section
extends Modelica.Constants;

//===========================================
//Equation section
equation
As = (di*lB*C)/Y;
G_s = G/As;
de = 4*(((Y^2)-((pi*(do^2))/4))/(pi*do));
Re = (G_s*de)/mu;
del_Pf = ((f*(G_s^2)*(N+1)*di)/(2*rho*de));
del_Pf1 = del_Pf/(g*rho);

end Ex9_10;

//============================================