//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.14, Page No.:444
//Title: Radiation from a black body
//===========================================
class Ex9_14
//===========================================
//Variable section
Real E(unit = "W/m3") "Emissive power";
Real e "Emissivity";
Real E_1(unit = "kW") "Radiated thermal output at 1600K";
Real P(unit = "%") "Percentage increase";
//===========================================
//Parameter section
parameter Real T(unit = "K") = 1500 "Temperature ";
parameter Real T_1(unit = "K") = 1600 "Temperature";
parameter Real Q(unit = "W") = 1000e3 "Radiated thermal output";
parameter Real sigma(unit = "W/m2K4") = 5.67e-8 "Stefan- Boltzmann constant";
parameter Real S(unit = "m2") = 10 "Surface area";

//===========================================
//Equation section
equation
E = Q/S;
e = E/(sigma*(T^4));
E_1 = e*sigma*(T_1^4);
P = Q-E_1;

end Ex9_14;
//===========================================