//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.18, Page No.:455
//Title: Radiation from a black body
//===========================================
class Ex9_18
//===========================================
//Variable section
Real r1(unit = "m") "Radius of top plate";
Real r4(unit = "m") "Radius of bottom plate";
Real R1 "R1 = r1/L";
Real R4 "R4 = r4/L";
Real S ;
Real F_14 "View factor";
Real F_12 "View factor";
Real F_11 "View factor";
Real F_13 "View factor";
Real A1(unit = "m2") "Area of plane surface";
Real Q1(unit = "W") "Rate of heat transfer by radiation in W";
Real Q1_1(unit = "kW") "Rate of heat transfer by radiation in kW";

//============================================
//Parameter section
parameter Real sigma(unit = "W/m2K4") = 5.67e-8 "Stefan- boltzmann constant";
parameter Real d1(unit = "m") = 1 "Diameter of top plate";
parameter Real L(unit = "m") = 0.5 "Distance between bottom and top plate";
parameter Real d4(unit = "m") = 1 "Diameter of bottom plate";
parameter Real T1(unit = "K") = 1200 "Temperature beneath hemisphere";
parameter Real T2(unit = "K") = 750 "Temperature of plate to be heated";
parameter Real T3(unit = "K") = 290 "Temperature of surroundings";

//=============================================
//Library section
extends Modelica.Constants;

//=============================================
//Equation section
equation
r1 = d1/2;
r4 = d4/2;
R1=r1/L;
R4=r4/L;
S=1+(1+R4^2)/(R1^2);
F_14=0.5*(S-(S^2-4*(r4/r1)^2)^0.5);
F_12=F_14;
//The summation rule states that
//F11+F12+F13=1
F_11=0;
F_13=1-F_12;
A1 = ((pi*(d1^2))/4);
Q1=(sigma*A1*F_12*((T1^4)-(T2^4)))+(sigma*A1*F_13*((T3^4)-(T2^4)));
Q1_1 = Q1/1000;
//1000 is divided to convert units from W to kW

end Ex9_18;
//==============================================