//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.22, Page No.:470
//Title: Radiation from gases
//=========================================
class Ex9_22
//=========================================
//Variable section
Real Pc(unit = "kN/m2") "partial pressure of carbondioxide in kN/m2";
Real Pc_1(unit = "bar") "partial pressure of carbondioxide in bar";
Real Pw(unit = "kN/m2")"partial pressure of water vapour in kN/m2";
Real Pw_1(unit = "bar")"partial pressure of water vapour in bar";
Real Le(unit = "m") "Mean beam length";
Real Pw_Le ;
Real P(unit = "bar") "Pressure";
Real mean_P(unit = "bar") "Mean pressure";
Real e_w;
Real Pc_Le;
Real e_c;
Real x(unit = "bar m") "x = (Pw+Pc)*Le" ;
Real y "y = (Pc/(Pc+Pw)";
Real e_g;
Real Pw_Le_Tr(unit = "bar m");
Real Pc_Le_Tr(unit = "bar m");
Real aw "Abosorptivity of water vapour";
Real e_w1;
Real e_c1;
Real ac "Abosorptivity of carbondioxide";
Real z "z = (Pw/(Pc+Pw))";
Real a "a = (Pc+Pw)*Le*(Ts/Tg)";
Real a_g;
Real Q(unit = "W") "Heat load in W";
Real Q_1(unit = "kW") "Heat load in kW";
Real Cg;
Real Qw(unit = "kW") "Net radiation to walls";

//============================================
//Parameter section
parameter Real p(unit = "%") = 10 "Percent of water vapour and carbondioxide";
parameter Real pv(unit = "kN/m2") = 150 "Vapour pressure of water vapour and carbondioxide"; 
parameter Real d(unit = "m")  = 0.5 "Diameter of combustion chamber";
parameter Real l(unit = "m") = 2 "Length of chamber";
parameter Real Ts(unit = "K") = 750 "Surface temperature";
parameter Real Tg(unit = "K") = 1250 "Temperature of combustion products";
parameter Real es = 0.5 "Emissivity";
// From Figure: 9.44, Page No.: 467, value of ew is
parameter Real ew = 0.075;
// From Figure: 9.44, Page No.: 467, value of Cw is
parameter Real Cw = 1.4;
// From Figure: 9.45, Page No.: 468, value of ec is
parameter Real ec = 0.037;
// From Figure: 9.38, Page No.: 450, value of Cc is
parameter Real Cc = 1.2;
// From Figure: 9.45, Page No.: 468, value of del_e is
parameter Real del_e = 0.001;
// From Figure: 9.44, Page No.: 467, value of ew at 750K is
parameter Real ew_1 = 0.12;
// From Figure: 9.45, Page No.: 468, value of ec at 750K is
parameter Real ec_1 = 0.08;
// From Figure: 9.38, Page No.: 450, value of Cc is
parameter Real Cc_1 = 1.02;
parameter Real sigma(unit = "W/m2K4") = 5.67e-8 "Stefan- Boltzman constant";
parameter Real del_a = 0;

//=================================================
//Library section
extends Modelica.Constants;

//=================================================
//Equation section
equation
Pc = (p/100)*pv;
Pc_1 = Pc/100;
Pw = (p/100)*pv;
Pw_1 = Pw/100;
Le = 3.6*((pi/4)*l*(d^2))/((2*(pi/4)*(d^2))+(d*pi*l));
Pw_Le = Pw_1*Le;
P = pv/100;
mean_P = (Pw_1+P)/2;
e_w = ew*Cw;
Pc_Le = Pc_1*Le;
e_c = ec*Cc;
x = (Pw_1+Pc_1)*Le;
y = (Pc_1/(Pc_1+Pw_1));
e_g = e_w+e_c-del_e;
Pw_Le_Tr = Pw_Le*(Ts/Tg);
Pc_Le_Tr = Pc_Le*(Ts/Tg);
e_w1 = ew_1*Cw;
aw = e_w1*((Tg/Ts)^0.45);
e_c1 = ec_1*Cc_1;
ac = e_c1*((Tg/Ts)^0.65);
z = (Pw_1/(Pc_1+Pw_1));
a = (Pc_1+Pw_1)*Le*(Ts/Tg);
a_g = aw+ac-del_a;
Q = (sigma*((2*(pi/4)*(d^2))+(d*pi*l))*((e_g*(Tg^4))-(a_g*(Ts^4))));
Q_1 = Q/1000;
//1000 is divided to convert units from W to kW
Cg = es/(1-((1-a_g)*(1-es)));
Qw = Q_1*Cg;
 
end Ex9_22;
//==========================================
