//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.32, Page No.:545
//Title: Finned tube units
//===========================================
model Ex9_32
//===========================================
//Variable section
Real b(unit = "m") "Perimeter";
Real A(unit = "m2") "Area";
Real m(unit = "1/m");
Real teta1(unit = "K") "Temperature";
Real L(unit = "m") "Length";
Real Qf(unit = "W per fin") "Heat loss per fin";
Real Qf_1(unit = "W/m") "Heat loss per metre run of tube W/m";
Real Qf_1_1(unit = "kW/m") "Heat loss per metre run of tube in kW/m";
//===========================================
//Parameter section
parameter Real d1(unit = "m") = 70e-3 "diameter of fin";
parameter Real d2(unit = "m") = 54e-3 "diameter of tube outer diameter";
parameter Real h(unit = "W/m2K") = 30 "Heat tansfer coefficient between gas and fin";
parameter Real w(unit = "m") = 2e-3 "Fin thickness";
parameter Real N = 230 "Number of fins per metre";
parameter Real k(unit = "W/mK") = 43 "Thermal conductivity"; 
parameter Real T1(unit = "K") = 370 "Surface temperature"; 
parameter Real T2(unit = "K") = 280 "Temperature of surroundings";

//==========================================
//Library section
extends Modelica.Constants;
extends Modelica.ComplexMath;
extends Modelica.Math;

//==========================================
//Equation section
equation
b = pi*(d1+d2);
A = ((pi*(d1+d2)*w)/2);
m = sqrt((h*b)/(k*A));
teta1 = (T1-T2);
L = (d1-d2)/2;
Qf = m*k*A*teta1*(((exp(2*m*L))-1)/(1+(exp(2*m*L))));
Qf_1 = Qf*N;
Qf_1_1 = Qf_1/1000;
//1000 is divided to convert W/m to kW/m

end Ex9_32;
//==========================================