//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.33, Page No.:556
//Title: Finned tube units
//===========================================
model Ex9_33
//===========================================
//Variable section
Real dw(unit = "m") "Mean diameter of do and di";
Real dm(unit = "m") "Log mean diameter of do and ds";
Real x;
Real y;
Real z;
Real a;
Real Q_l_1(unit = "W/m") "Heat loss per unit length in W/m";
Real del_T_lagging(unit = "K") "Lag in temperature difference";
Real del_T(unit = "K") "Temperature difference";
Real hr(unit = "W/m2K") "Heat transfer coefficient";
Real hc(unit = "W/m2K") "Heat transfer coefficient";
Real Q_l(unit = "W/m") "Heat loss";
Real hr_hc_1(unit = "W/m2K") "Heat transfer coefficient";
Real Q_l_2(unit = "kW/m") "Heat loss per unit length in kW/m";

//===========================================
//Parameter section
parameter Real d(unit = "m") = 150e-3 "inner diameter";
parameter Real do(unit = "m") = 168e-3 "outer diameter";
parameter Real ds(unit = "m") = 268e-3;
parameter Real xw(unit = "m") = 9e-3 "Wall thickness";
parameter Real xl(unit = "m") = 50e-3;
parameter Real hi(unit = "W/m2K") = 8500 "Heat transfer coefficient";
parameter Real kw(unit = "W/mK") = 45 "Thermal conductivity";
parameter Real kl(unit = "W/mK") = 0.073 "Thermal conductivity";
parameter Real hr_hc(unit = "W/m2K") = 10 "Heat transfer coefficient";
parameter Real T1(unit = "K") = 444 "Steam temperature";
parameter Real T2(unit = "K") = 294 "Temperature of air";
//From Table: 9.5, Page No.: 435 value of C and n for air are 
parameter Real C = 1.32;
parameter Real n = 0.25;
parameter Real e = 0.9 "Emissivity";
parameter Real sigma(unit = "W/m2K4") = 5.67e-8 "Stefan- Boltzmann coefficient";
parameter Real hr_hc_2(unit = "W/m2K") = 20 "At 150K heat transfer coefficient";

//===========================================
//Library section
extends Modelica.Constants;

//===========================================
//Equation section
equation
dw = (d+do)/2;
dm = (ds+do)/2;
x = (1/(hi*pi*d));
y = (xw/(kw*pi*dw));
z = (xl/(kl*pi*dm));
a = (1/(hr_hc*pi*ds));
Q_l_1 = (T1-T2)/(z+a);
del_T_lagging = ((z/(z+a))*(T1-T2));
del_T = T1-del_T_lagging;
hr = ((e*sigma*((del_T^4)-(T2^4)))/(del_T-T2));
hc = C*(((del_T-T2)/ds)^n);
hr_hc_1 = hr+hc;
Q_l = (hr_hc_2*pi*do*(T1-T2));
Q_l_2 = Q_l/1000;
//1000 is divided to convert W/m to kW/m

end Ex9_33;
//=========================================