//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.8, Page No.:413
//Title: Conduction with internal heat source
//============================================
model Ex9_8

//============================================
//Variable section
Real Q_l(unit = "W/m") "Heat release rate per length";
Real del_T(unit = "K") "Arithmetic mean temperature";

//===========================================
//Parameter section
parameter Real Q(unit = "W") = 0.25e6 "Heat release rate";
parameter Real k(unit = "W/mK") = 33 "Thermal conductivity of uranium";
parameter Real l(unit = "m") = 5 "length of reactor";
//===========================================
//Library section
extends Modelica.Constants;

//===========================================
//Equation section
equation
Q_l = Q/l;
del_T = Q_l/(4*pi*k);

end Ex9_8;
//===========================================