//Coulson & Richardson's Chemical Engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.10, Page No.: 630
//Title : Mass transfer and chemical reaction
//===========================================
model Ex10_11
//===========================================
//Variable section
Real A;
Real power;
Real power_1;
Real k_313(unit = "1/s") "Rate constant at 313K";
Real r;
//r = NA_313/NA_293

//===========================================
//Parameter section
parameter Real k_293(unit = "1/s") = 2.5e-6 "Rate constant at 293K";
parameter Real Ea(unit = "J/kmol") = 2.643e7 "Activation energy";
parameter Real R(unit = "J/kmol.K") = 8314 "Universal gas constant";
parameter Real D(unit = "m2/s") = 1e-9 "Molecular diffusivity";
parameter Real L(unit = "m") = 10e-3 "film thickness";
parameter Real n = 0.8 "solubility of gas at 313K is 80% of solubility at 293K";
parameter Real T1(unit = "K") = 293 "Temperature";
parameter Real T2(unit = "K") = 313 "Temperature";

//===========================================
//Library section
extends Modelica.Math;
extends Modelica.ComplexMath;

//===========================================
//Equation section
equation
A = k_293/exp(-Ea/(R*T1));
power = exp((-2)*L*(sqrt(k_293/D)));
// At 313K
k_313 = A*exp(-Ea/(R*T2));
power_1 = exp((-2)*L*(sqrt(k_313/D)));
//NA_1 = CAS_1*(((k_293/D)^(1/2))*((1+power)/(1-power))
//NA_2 = CAS*((k_313/D)^(1/2))*((1+power_1)/(1-power_1))
// r = NA_2/NA_1
// CAS = n*CAS_1
r = (n*(sqrt(k_313/D))*((1+power_1)/(1-power_1)))/((sqrt(k_293/D))*((1+power)/(1-power)));

//===========================================

end Ex10_11;

//===========================================