//Coulson & Richardson's Chemical engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.14, Page No.: 645
//Title : Mass transfer and chemical reaction with a mass transfer resistance external to the pellet
//==============================================
model Ex10_14
//==============================================
//Variable section
Real k(unit = "1/s") "Rate constant";
Real phi_l "Thiele modulus";
Real eta "Effectiveness factor";
Real eta_1 "Effectiveness factor";
Real L;
Real r(unit = "m") "radius of pellet";
//==============================================
//Parameter section
parameter Real CAi(unit = "kmol/m3") = 0.011 "Reactant concentration";
parameter Real De(unit = "m2/s") = 7.5e-8 "Effective diffusivty";
parameter Real d(unit = "m") = 2e-3 "mean diameter";
parameter Real rA(unit = "kmol/m3 catalyst") = 8.2e-2 "Reaction rate";

//==============================================
//Library section
extends Modelica.Math;
extends Modelica.ComplexMath;

//==============================================
//Equation section
equation
r = d/2;
L = r/3;
phi_l = (sqrt(k/De))*L;
eta = (1/phi_l);
rA = eta*k*CAi;
eta_1 = (1/phi_l)*((1/tanh(3*phi_l))-(1/(3*phi_l)));

end Ex10_14;

//==============================================