//Coulson & Richardson's Chemical engineering, Volume-01, 6th edition
//Chapter-10, Mass Transfer 
//Exercise-10.9, Page No.: 628
//Title : Mass transfer and chemical reaction
//==============================================
model Ex10_9

//==============================================
//Variable section
Real R "Ratio of mass flux";
Real NA_1(unit = "kmol/m2s") "mass flux at y = l";
Real NA_2(unit = "kmol/m2s") "mass flux at y = 0";

//==============================================
//Parameter section
parameter Real r = 0.693 "Numerical value of ratio = l*((k/D)^0.5)";

//==============================================
//Library section
extends Modelica.Math;

//==============================================
//Equation section
equation
NA_1 = ((exp(r)+exp(-r))-4);
NA_2 = (2*(1-exp(-r)-exp(r)));
R = NA_1/NA_2;

end Ex10_9;

//==============================================